# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name:		burp
Epoch:		1
Version:	2.5.4
Release:	alt5
Summary:	A network-based backup and restore program (deprecated)
License:	AGPL-3.0 and BSD and GPLv2+ and LGPLv2+
Group:		Archiving/Backup
Url:		https://burp.grke.org/
Vcs:		https://github.com/grke/burp.git

%add_findreq_skiplist %_datadir/%name/scripts/*

Source:		%name-%version.tar
BuildRequires:  check
BuildRequires:  libacl-devel
BuildRequires:  libcap-devel
BuildRequires:  libcheck-devel
BuildRequires:  libncurses-devel
BuildRequires:  librsync-devel
BuildRequires:  libtool
BuildRequires:  libuthash-devel
BuildRequires:  libyajl-devel
BuildRequires:  openssl
BuildRequires:  openssl-devel
BuildRequires:  zlib-devel

%description
Burp is a network backup and restore program, using client and server.
It uses librsync in order to save network traffic and to save on the
amount of space that is used by each backup.

ATTENTION: This software has been unmaintained for years, introducing
   potential critical infrastructural risks to systems relying on it!
   Users are strongly advised to transition to a maintained backup
   solutions, such as restic (or resticprofile / autorestic)!

# 2.5.4: client_protocol1_backup_phase2 test fails with lto
# and librsync >= 2.0.1
%define optflags_lto %nil

%prep
%setup

# Replace implicit root user with _burp user and readall=1.
sed -i  -e 's/# \(user\|group\)=\(nogroup\|graham\)/\1 = _burp/' \
	-e 's/# readall=1/readall = 1/' \
	-e 's/=\/home/ = \/boot/' \
	-e 's/\(exclude_comp\)=/\1 = /' \
	configs/*/burp.conf.in

%build
%define _localstatedir %_var
%add_optflags -Wno-error=unused-variable
%autoreconf
%configure \
    --sysconfdir="%_sysconfdir/burp" \
    --disable-static

%make_build

%install
%makeinstall_std install-all
install -D -p -m 0755 .gear/burp.init %buildroot%_initrddir/burp-server
install -D -p -m 0644 .gear/burp.service %buildroot%_unitdir/burp-server.service
%__subst "s,password,#password,g" %buildroot%_sysconfdir/burp/clientconfdir/testclient

%check
if ! %make_build check; then
	cat test-suite.log
	exit 1
fi
.gear/test-burp.sh

%files
%doc %_docdir/%name/
%_initrddir/burp-server
%_unitdir/burp-*.*
%dir %_datadir/%name/
%_datadir/%name/scripts/
%_bindir/vss_strip
%_sbindir/*
%_man8dir/*
%defattr(640,root,_burp,0770)
%dir %_spooldir/%name/
%defattr(640,root,_burp,3770)
%dir %_sysconfdir/burp/
%dir %_sysconfdir/burp/CA-client/
%dir %_sysconfdir/burp/clientconfdir/
%dir %_sysconfdir/burp/clientconfdir/incexc/
%config(noreplace) %_sysconfdir/burp/*.c*nf
%config(noreplace) %_sysconfdir/burp/clientconfdir/testclient
%config(noreplace) %_sysconfdir/burp/clientconfdir/incexc/example

%pre
/usr/sbin/groupadd -r -f _burp
/usr/sbin/useradd -r -g _burp -d /var/empty -s /dev/null -n -c "BURP BackUp and Restore Program" _burp >/dev/null 2>&1 ||:

%post
%post_service burp-server
echo >&2 "%name is deprecated. Please switch to another backup solution."

%preun
%preun_service burp-server

%changelog
