%define _unpackaged_files_terminate_build 1

%ifarch x86_64 aarch64
%def_with check
%else
%def_without check
%endif

Name: btrfs-progs
Version: 6.17.1
Release: alt1

Summary: Utilities for managing the Btrfs filesystem
License: GPLv2
Group: System/Kernel and hardware
Url: https://btrfs.readthedocs.io
VCS: git://git.kernel.org/pub/scm/linux/kernel/git/kdave/btrfs-progs.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires: libacl-devel
BuildRequires: libe2fs-devel
BuildRequires: libuuid-devel
BuildRequires: zlib-devel
BuildRequires: libblkid-devel
BuildRequires: libattr-devel
BuildRequires: liblzo2-devel
BuildRequires: asciidoc
BuildRequires: xmlto
BuildRequires: libzstd-devel
BuildRequires: libudev-devel
BuildRequires: libselinux-devel
BuildRequires: python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme
%if_with check
BuildRequires: /proc /dev/kvm
BuildRequires: /sbin/dmsetup
BuildRequires: /usr/bin/setfattr
BuildRequires: /usr/bin/getfacl
BuildRequires: /sbin/udevadm
BuildRequires: rpm-build-vm
BuildRequires: libaio-devel
BuildRequires: liburing-devel
%endif

%description
Btrfs (B-tree FS or usually pronounced "Butter FS") is a copy-on-write
file system for Linux. It was created as a response to the ZFS filesystem,
in order to replace the ext3 file system while removing a number of its
limitations, particularly with respect to file size, total file system size
and filesystem check duration; it is also expected to implement modern
filesystem features not supported by ext3, like writable snapshots,
snapshots of snapshots, builtin RAID support, and subvolumes. In addition,
Btrfs claims a "focus on fault tolerance, repair and easy administration".

This package contains utilities for managing the Btrfs filesystem

%package -n libbtrfs-devel
Summary:	btrfs filesystem-specific libraries and headers
Group:		Development/C
Requires:	libbtrfs = %version-%release
Provides:	%name-devel

%description -n libbtrfs-devel
btrfs-progs-devel contains the libraries and header files needed to
develop btrfs filesystem-specific programs.

You should install btrfs-progs-devel if you want to develop
btrfs filesystem-specific programs.


%package -n libbtrfs
Summary:	btrfs filesystem-specific libraries and headers
Group:		System/Kernel and hardware

%description -n libbtrfs
btrfs-progs-devel contains shared libraries needed to
btrfs filesystem-specific programs.


%prep
%setup -q
%patch0 -p1

%build
autoreconf -fisv -I m4
automake --add-missing ||:
%configure --disable-python \
	   --disable-static \
	   --with-pkgconfigdir=%_pkgconfigdir \
	   #
%make_build

%install
%makeinstall_std bindir=%_bindir libdir=%_libdir incdir=%_includedir/
mkdir -p %buildroot%_libdir %buildroot%_sbindir %buildroot/sbin
ln %buildroot%_bindir/btrfs %buildroot%_sbindir/btrfs
ln %buildroot%_bindir/btrfs %buildroot/sbin/btrfs

install -pD -m644 btrfs-completion %buildroot%_datadir/bash-completion/completions/btrfs

%check
# failed: setfattr -n user.foo -v bar1 /usr/src/RPM/BUILD/btrfs-progs-5.16/tests/mnt/acls/acls.1
rm -rf tests/convert-tests/001-ext2-basic
rm -rf tests/convert-tests/002-ext3-basic
rm -rf tests/convert-tests/003-ext4-basic
rm -rf tests/convert-tests/005-delete-all-rollback

rm -rf tests/convert-tests/*-reiserfs-*

# mknod is not allowed in virtual environment
rm -rf tests/mkfs-tests/009-special-files-for-rootdir
# don't run all fuzzing tests
rm -rf tests/fuzz-tests/0*

# Needs 'null_blk' kernel module
rm -rf tests/mkfs-tests/025-zoned-parallel

rm -rf "$HOME/new_tmp"
mkdir "$HOME/new_tmp"
TMPDIR="$HOME/new_tmp"
vm-run --sbin --udevd --kvm=cond make V=1 TEST_LOG=dump test-mkfs

%pretrans -p <lua>
st = posix.stat("/usr/bin/btrfs")
if st and st.type == "link" then
  os.remove("/usr/bin/btrfs")
end


%files
/sbin/*
%_bindir/*
%_sbindir/*
%_udevrulesdir/*.rules
%_datadir/bash-completion/completions/btrfs
%_man8dir/*
%_man2dir/*
%_man5dir/*

%files -n libbtrfs
%_libdir/*.so.*

%files -n libbtrfs-devel
%_libdir/*.so
%_pkgconfigdir/libbtrfsutil.pc
%_includedir/*

%changelog
