%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define _localstatedir %_var
%filter_from_requires /^sudo$/d

%define pkg_version 6.8
%define xdg_name org.a11y.brlapi
%define api_ver 0.8.7
%define _exec_prefix %nil
%define _jnidir %_libdir/java

%def_with at_spi2
%def_with python3
%def_with speech_dispatcher

%def_without at_spi1
%def_without ocaml
%def_without tcl
%if_with tcl
%{!?tcl_version: %define tcl_version %(echo 'puts $tcl_version' | tclsh)}
%{!?tcl_sitearch: %define tcl_sitearch %prefix/%_lib/tcl%tcl_version}
%endif

Name: brltty
Version: %pkg_version
Release: alt2

Summary: Braille display driver for Linux/Unix
Group: System/Servers
License: GPL-2.0-or-later
Url: http://mielke.cc/brltty/

Vcs: https://github.com/brltty/brltty.git
# Source-url: http://mielke.cc/brltty/archive/%name-%version.tar.xz
Source: %name-%version.tar
Source2: ru_brltty.tar

Patch2: fix-speechd-includes.patch

%define cython_ver 0.18

BuildRequires(pre): rpm-build-java
BuildRequires: libappstream-glib-devel
BuildRequires: gcc-c++ libbluez-devel libalsa-devel libgpm-devel
# for updusbdevs and udev rules
BuildRequires: tcl
BuildRequires: byacc glibc-kernheaders
BuildRequires: /proc java-devel
BuildRequires: pkgconfig(systemd) libudev-devel
BuildRequires: doxygen python3-module-docutils
%{?_with_at_spi2:BuildRequires: libat-spi2-core-devel}
%{?_with_speech_dispatcher:BuildRequires: libspeechd-devel}
%{?_with_python3:
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools python3-module-Cython >= %cython_ver}
%{?_with_tcl:BuildRequires: tcl-devel}
%{?_with_ocaml:BuildRequires: ocaml findlib}
# for XWindow driver
BuildRequires: libSM-devel libICE-devel libX11-devel libXaw-devel libXext-devel libXt-devel libXtst-devel
BuildRequires: libtinfo-devel

%description
BRLTTY is a background process (daemon) which provides
access to the Linux/Unix console (when in text mode)
for a blind person using a refreshable braille display.
It drives the braille display and provides complete
screen review functionality.

%if_with speech_dispatcher
BRLTTY can also work with speech synthesizers; if you want to use it with
Speech Dispatcher, please install also package %name-speech-dispatcher.

%package speech-dispatcher
Summary: Speech Dispatcher driver for BRLTTY
Group: System/Servers
License: GPL-2.0-or-later
Requires: %name = %pkg_version-%release

%description speech-dispatcher
This package provides the Speech Dispatcher driver for BRLTTY.
%endif

%package xw
Summary: XWindow driver for BRLTTY
Group: System/Servers
License: GPL-2.0-or-later

Requires: %name = %pkg_version-%release
%description xw
This package provides the XWindow driver for BRLTTY.

%if_with at_spi1
%package at-spi
Summary: AtSpi driver for BRLTTY
Group: System/Servers
# The data files are licensed under LGPLv2+, see the README file.
License: GPL-2.0-or-later and LGPL-2.0-or-later
BuildRequires: libat-spi-devel
Requires: %name = %pkg_version-%release
%description at-spi
This package provides the AtSpi driver for BRLTTY.
%endif

%if_with at_spi2
%package at-spi2
Summary: AtSpi2 driver for BRLTTY
Group: System/Servers
# The data files are licensed under LGPLv2+, see the README file.
License: GPL-2.0-or-later and LGPL-2.0-or-later
Requires: %name = %pkg_version-%release

%description at-spi2
This package provides the AtSpi2 driver for BRLTTY.
%endif

%package -n brlapi
Version: %api_ver
Group: File tools
License: LGPL-2.0-or-later
Summary: Application Programming Interface for BRLTTY

%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application which directly accesses
a refreshable braille display.

%package -n brlapi-devel
Version: %api_ver
Group: Development/C
License: LGPL-2.0-or-later
Requires: brlapi = %api_ver-%release
Summary: Headers, static archive, and documentation for BrlAPI

%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically attuned to their needs.

Install this package if you are developing or maintaining an application
which directly accesses a refreshable braille display.

%package -n tcl-brlapi
Version: %api_ver
Summary: Tcl binding for BrlAPI
Group: Development/Tcl
License: LGPL-2.0-or-later
Requires: brlapi = %api_ver-%release

%description -n tcl-brlapi
This package provides the Tcl binding for BrlAPI.

%package -n python3-module-brlapi
Version: %api_ver
Summary: Python binding for BrlAPI
Group: Development/Python
License: LGPL-2.0-or-later
Requires: brlapi = %api_ver-%release

%description -n python3-module-brlapi
This package provides the Python3 binding for BrlAPI.

%package -n brlapi-java
Version: %api_ver
Summary: Java binding for BrlAPI
Group: Development/Java
License: LGPL-2.0-or-later
Requires: brlapi = %api_ver-%release

%description -n brlapi-java
This package provides the Java binding for BrlAPI.

%if_with ocaml
%package -n ocaml-brlapi
Version: %api_ver
Summary: OCaml binding for BrlAPI
Group: Development/Other
License: LGPL-2.0-or-later
Requires: brlapi = %api_ver-%release

%description -n ocaml-brlapi
This package provides the OCaml binding for BrlAPI.
%endif

%prep
%setup
%if_with speech_dispatcher
%patch2 -p2
%endif

sed -i 's;\/usr\(/bin/true\);\1;' Autostart/Systemd/brltty-device@.service

%build
%add_optflags %(getconf LFS_CFLAGS)

./autogen

# Add the openjdk include directories to CPPFLAGS
for i in -I/usr/lib/jvm/java/include{,/linux}; do
      java_inc="$java_inc $i"
done
export CPPFLAGS="$java_inc"

# there is no curses packages in BuildRequires, so the package builds
# without them in mock; let's express this decision explicitly
opts="--disable-stripping --without-curses --libdir=%_libdir \
%if_with speech_dispatcher
  --with-speechd=%prefix \
%endif
  --with-install-root=%buildroot"

%configure $opts PYTHON=%__python3
%make_build

find . \( -path ./doc -o -path ./Documents \) -prune -o \
  \( -name 'README*' -o -name '*.txt' -o -name '*.html' -o \
     -name '*.sgml' -o -name '*.patch' -o \
     \( -path './Bootdisks/*' -type f -perm /ugo=x \) \) -print |
while read file; do
   mkdir -p doc/${file%%/*} && cp -rp $file doc/$file || exit 1
done

find . -name '*.sgml' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done
find . -name '*.txt' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done
find . -name 'README*' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done

%install
%define install_opts JAVA_JNI_DIR=%_jnidir INSTALL_X11_AUTOSTART_DIRECTORY=%buildroot%_x11sysconfdir/xsession.user.d INSTALL_PKGCONFIG_DIRECTORY=%buildroot%_pkgconfigdir
%make %install_opts install

install -d -m755 %buildroot{%_sysconfdir,%_man5dir}
install -m644 Documents/brltty.conf %buildroot%_sysconfdir
echo ".so man1/brltty.1" > %buildroot%_man5dir/brltty.conf.5

install -m 755 Bindings/Java/libbrlapi_java.so "%buildroot%_jnidir/"

# clean up the manuals:
rm -rf Documents/BrlAPIref/BrlAPIref/html
mv -f Documents/BrlAPIref/{html,BrlAPIref}

# Don't want static lib
rm -rf %buildroot/%_libdir/lib*.a

%__subst s/'#text-table.ru'/'text-table ru'/ %buildroot/etc/brltty.conf
%__cp %SOURCE2 ru_brltty.tar
tar xf ru_brltty.tar
%__cp ru_brltty/* %buildroot%_sysconfdir/brltty/

# create temporary directory
mkdir -p %buildroot%_tmpfilesdir
cat > %buildroot%_tmpfilesdir/%name.conf << _EOF_
d /run/%name 0755 root root -
_EOF_

# install polkit rules
pushd Authorization/Polkit
%makeinstall_std
popd

# udev rules
#install -pD -m644 Autostart/Udev/ %buildroot%_udevrulesdir/95-%name.rules
pushd Autostart/Udev
%makeinstall_std UDEV_RULES_LOCATION=%_udevrulesdir
popd

# systemd unit
%make -C Autostart/Systemd SYSTEMD_UNITS_DIRECTORY=%buildroot%_unitdir install
mkdir -p %buildroot%_unitdir
install -m 644 Autostart/Systemd/*.{service,path} %buildroot%_unitdir/

chmod +x %buildroot%_bindir/%name-config.sh

%find_lang %name

%files -f %name.lang
%config(noreplace) %_sysconfdir/brltty.conf
%dir %_sysconfdir/brltty
%_sysconfdir/brltty/
%_sysusersdir/%name.conf
%_udevrulesdir/90-%name-hid.rules
%_udevrulesdir/90-%name-uinput.rules
%_udevrulesdir/90-%name-usb-customized.rules
%_udevrulesdir/90-%name-usb-generic.rules
%_tmpfilesdir/%name.conf
%_unitdir/brltty@.service
%_unitdir/%name-device@.service
%_unitdir/*.path
%_datadir/polkit-1/rules.d/org.a11y.brlapi.rules
%dir %_libexecdir/%name
# bash script
%_libexecdir/%name/systemd-wrapper
%_libexecdir/%name/udev-wrapper
%_datadir/polkit-1/actions/%xdg_name.policy
%_bindir/brltty
%_bindir/brltty-*
%exclude %_bindir/brltty-config.sh
%_bindir/eutp
%_libdir/brltty/
%exclude %_libdir/brltty/libbrlttybba.so
%exclude %_libdir/brltty/libbrlttybxw.so
%if_with speech_dispatcher
%exclude %_libdir/brltty/libbrlttyssd.so
%endif
%if_with at_spi1
%exclude %_libdir/brltty/libbrlttyxas.so
%endif
%if_with at_spi2
%exclude %_libdir/brltty/libbrlttyxa2.so
%endif
%_man1dir/brltty.*
%_man1dir/eutp.1.*
%_man5dir/brltty.*
#%_datadir/metainfo/org.a11y.brltty.metainfo.xml
%doc LICENSE-LGPL
%doc Documents/ChangeLog Documents/TODO
%doc Documents/Manual-BRLTTY/
%doc doc/*

%if_with speech_dispatcher
%files speech-dispatcher
%doc Drivers/Speech/SpeechDispatcher/README
%_libdir/brltty/libbrlttyssd.so
%endif

%files xw
%doc Drivers/Braille/XWindow/README
%_x11sysconfdir/xsession.user.d/90xbrlapi
%_libdir/brltty/libbrlttybxw.so

%if_with at_spi1
%files at-spi
%_libdir/brltty/libbrlttyxas.so
%endif

%if_with at_spi2
%files at-spi2
%_libdir/brltty/libbrlttyxa2.so
%_datadir/gdm/greeter/autostart/xbrlapi.desktop
%endif

%files -n brlapi
%_bindir/vstp
%_bindir/xbrlapi
%dir %_libdir/brltty
%_libdir/brltty/libbrlttybba.so
%_libdir/libbrlapi.so.*
%doc Drivers/Braille/XWindow/README
%doc Documents/Manual-BrlAPI/
%doc %_mandir/man1/xbrlapi.*
%doc %_mandir/man1/vstp.*

%files -n brlapi-devel
%_bindir/%name-config.sh
%_libdir/libbrlapi.so
%_includedir/brltty
%_includedir/brlapi*.h
%_pkgconfigdir/brltty.pc
%_man3dir/brlapi_*.3*
%doc Documents/BrlAPIref/BrlAPIref/

%if_with tcl
%files -n tcl-brlapi
%tcl_sitearch/brlapi-%api_ver
%endif

%if_with python3
%files -n python3-module-brlapi
%python3_sitelibdir/brlapi*.so
%python3_sitelibdir/Brlapi-%api_ver-*.egg-info
%endif

%files -n brlapi-java
%_jnidir/libbrlapi_java.so
%_javadir/brlapi.jar

%if_with ocaml
%files -n ocaml-brlapi
%dir %_libdir/ocaml/brlapi/
%_libdir/ocaml/brlapi/
#_libdir/ocaml/stublibs/
%endif

%changelog
