# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

# Based on https://github.com/iovisor/bpftrace/blob/master/INSTALL.md

Name: bpftrace
Version: 0.24.1
Release: alt1
Summary: High-level tracing language for Linux eBPF
Group: Development/Debuggers
License: Apache-2.0
Url: https://github.com/bpftrace/bpftrace
# Docs: https://github.com/iovisor/bpftrace/blob/master/docs/reference_guide.md
# Docs: https://github.com/iovisor/bpftrace/blob/master/docs/tutorial_one_liners.md
# Docs: http://www.brendangregg.com/BPF/bpftrace-cheat-sheet.html
# Docs: http://www.brendangregg.com/ebpf.html#bpftrace
# PR: https://lwn.net/Articles/793749/
# PR: http://www.brendangregg.com/blog/2018-10-08/dtrace-for-linux-2018.html

Source: %name-%version.tar
ExclusiveArch:	x86_64 aarch64 loongarch64 riscv64

%define llvm_ver 19
%define llvm_pkgver %llvm_ver.1
BuildRequires(pre): rpm-macros-cmake
BuildRequires: asciidoctor
BuildRequires: binutils-devel
BuildRequires: cereal-devel
BuildRequires: clang%llvm_pkgver-devel
BuildRequires: cmake
BuildRequires: flex
BuildRequires: gcc-c++
BuildRequires: libbcc-devel
BuildRequires: libbpf-devel
BuildRequires: libdw-devel
BuildRequires: libelf-devel
BuildRequires: libpcap-devel
BuildRequires: libstdc++-devel
BuildRequires: libstdc++-devel-static
BuildRequires: llvm%llvm_pkgver-devel
BuildRequires: /proc
BuildRequires: python3-module-setuptools
BuildRequires: xxd

# Assuming 'kernel' dependency will bring un-def kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires(pre): rpm-build-kernel
BuildRequires: bc
BuildRequires: bpftool
BuildRequires: dwarves
BuildRequires: iproute2
BuildRequires: iputils
BuildRequires: kernel-headers-modules-%kernel_latest
BuildRequires: libgtest-devel
BuildRequires: python3(looseversion)
BuildRequires: rpm-build-vm
}}

%description
bpftrace is a high-level tracing language for Linux enhanced Berkeley
Packet Filter (eBPF) available in recent Linux kernels (4.x). bpftrace
uses LLVM as a backend to compile scripts to BPF-bytecode and makes use of
BCC for interacting with the Linux BPF system, as well as existing Linux
tracing capabilities: kernel dynamic tracing (kprobes), user-level dynamic
tracing (uprobes), and tracepoints. The bpftrace language is inspired by
awk and C, and predecessor tracers such as DTrace and SystemTap. bpftrace
was created by Alastair Robertson.

%prep
%setup

%build
# -DBUILD_TESTING:BOOL=ON will require googletest and try to clone it from github
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
%if_disabled check
	-DBUILD_TESTING:BOOL=OFF \
%endif
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_DIR=$(llvm-config-%llvm_ver --cmakedir) \
	-DClang_DIR=$(llvm-config-%llvm_ver --cmakedir)/../clang \
	-DOFFLINE_BUILDS:BOOL=ON \
	-DALLOW_UNSAFE_PROBE:BOOL=ON \
	-DUSE_SYSTEM_BPF_BCC:BOOL=ON \
	%nil
%cmake_build

%install
%cmake_install
find %buildroot%_datadir/%name/tools -name '*.bt' | xargs chmod a+x

# Fix man pages.
pushd %buildroot%_man8dir
 rename '' bpftrace- *.gz
 rename bpftrace-bpftrace bpftrace bpftrace-bpftrace*.gz
popd

# Need to keep BEGIN_trigger and END_trigger
# https://github.com/iovisor/bpftrace/issues/954
%brp_strip_debug %_bindir/bpftrace

%check
%_cmake__builddir/src/bpftrace --version	 # not requires root
vm-run %_cmake__builddir/src/bpftrace --info # should be fast enough even w/o kvm
vm-run --kvm=cond %_cmake__builddir/src/bpftrace -l 'kprobe:*_sleep_*'
if kvm-ok; then
	PATH=$PWD/.gear:$PATH
	cd %_cmake__builddir
	delete-blocks hardware	tests/runtime/probe
	delete-blocks testprogs	tests/runtime/*
%ifarch aarch64
	sed -i 's/xattr.h/user.h/' tests/runtime/basic
%endif
	vm-run --kvm=cond --sbin tests/runtime-tests.sh
fi

%files
%define _customdocdir %_docdir/%name
%doc LICENSE README.md CHANGELOG.md CONTRIBUTING-TOOLS.md
%doc docs/reference_guide.md docs/tutorial_one_liners.md
%_bindir/*
%_datadir/%name
%_man8dir/*
%_datadir/bash-completion/completions/bpftrace

%changelog
