Name: bogofilter
Version: 1.2.5
Release: alt2

Summary: Fast anti-spam filtering by Bayesian statistical analysis
Summary(ru_RU.CP1251):        
Group: Networking/Mail
License: GPL-2.0-or-later AND GPL-3.0-only
URL: http://bogofilter.sourceforge.net/

Packager: Ilya Mashkin <oddity@altlinux.ru>

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Source0: %name-%version.tar
Patch0001: 0001-ALT-Hide-qmail-inject-from-dependency-search-because.patch
Patch0002: 0002-DEBIAN-Make-bf_tar-use-tar-instead-of-pax-to-drop-de.patch

Requires: %name-bdb
Requires: %name-doc

BuildRequires(pre): rpm-macros-alternatives

BuildRequires: flex
BuildRequires: libgsl-devel >= 1.4
BuildRequires: libdb4.7-devel
BuildRequires: libsqlite3-devel
BuildRequires: perl-Pod-Parser

%description
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms  (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

%description -l ru_RU.CP1251
Bogofilter         .  
        
  ,     
""  "" ,   ,   
   . Bogofilter    
(  Berkeley DB),   C,    , 
      ,   
 .

%package bdb
Summary: Fast anti-spam filtering by Bayesian statistical analysis with Berkeley DB backend
Group: Networking/Mail

Requires: %name-common = %EVR
Provides: %name-backend = %EVR

Provides: bogofilter-tuning
Obsoletes: bogofilter-tuning

Provides: bogofilter-utils = %EVR
Obsoletes: bogofilter-utils <= 1.2.5-alt1

%description bdb
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms  (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

This package contains %name build with the Berkeley DB backend.


%package sqlite
Summary: Fast anti-spam filtering by Bayesian statistical analysis with SQLite backend
Group: Networking/Mail

Provides: %name-backend = %EVR
Requires: %name-common = %EVR

%description sqlite
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms  (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

This package contains %name build with the sqlite3 backend.


%package common
Summary: Common files for Bogofilter
Group: Networking/Mail
BuildArch: noarch

%description common
This package contains shared files for various %name backends


%package contrib
Summary: Scripts contributed to Bogofilter
Group: Networking/Mail
BuildArch: noarch
Requires: %name-backend = %version-%release

AutoReq: yes, noperl, noshell

%description contrib
Helpful scripts contributed to the bogofilter package.
Bogofilter is a Bayesian spam filter.


%package doc
Summary: Bogofilter documentation
Group: Networking/Mail
BuildArch: noarch

%description doc
This package contains the documentation of bogofilter.

%prep
%setup -q
%autopatch -p2

%build
%define _configure_script ../configure

build()
{
	local flavour=$1; shift

	mkdir -p build-$flavour
	cd build-$flavour

	%configure \
		--disable-dependency-tracking \
		--disable-rpath \
		"$@" ||
		return $?

	%make_build ||
		return $?
	cd -
}

mkdir -p build-common
cd build-common
%configure
cd -

build bdb    --program-suffix=-bdb    --with-database=db
build sqlite --program-suffix=-sqlite --with-database=sqlite

%install
%define _makeinstall_target install-exec-recursive

%makeinstall_std -C build-common/doc install

mkdir -p --  $RPM_BUILD_ROOT%_altdir
for o in bdb sqlite; do
	%makeinstall_std -C "build-$o" \
		mandir="/.ignore"
	{
		printf '%%s\t%%s\t1\n' "%_bindir/bogofilter" "%_bindir/bogofilter-$o"
		find "$RPM_BUILD_ROOT%_bindir" -type f \
			\( -name "*-$o" -a \! -name "bogofilter-$o" \) \
			-printf '%%f\n' | sort |
			sed -re 's|(.*)-([^-]+)$|%_bindir/\1\t%_bindir/&\t%_bindir/bogofilter-\2|'
	} > "$RPM_BUILD_ROOT%_altdir/%name-$o"
done
rm -rf -- "$RPM_BUILD_ROOT/.ignore"

mkdir -p -m755 -- $RPM_BUILD_ROOT%_datadir/%name/contrib
find contrib -type f \
	! \( -name 'Makefile*' -o -name '*.[co]' -o -name '*.Po' \) \
	-execdir cp -pt "$RPM_BUILD_ROOT%_datadir/%name/contrib" -- '{}' '+'

%check
%make -C build-bdb check
%make -C build-sqlite check

%files

%files common
%_sysconfdir/bogofilter.cf.example
%_man1dir/bogofilter.1*
%_man1dir/bf_*.1*
%_man1dir/bogolexer.1*
%_man1dir/bogotune.1*
%_man1dir/bogoupgrade.1*
%_man1dir/bogoutil.1*

%files bdb
%_altdir/bogofilter-bdb
%_bindir/bogofilter-bdb
%_bindir/bf_compact-bdb
%_bindir/bf_copy-bdb
%_bindir/bf_tar-bdb
%_bindir/bogolexer-bdb
%_bindir/bogotune-bdb
%_bindir/bogoupgrade-bdb
%_bindir/bogoutil-bdb

%files sqlite
%_altdir/bogofilter-sqlite
%_bindir/bogofilter-sqlite
%_bindir/bf_compact-sqlite
%_bindir/bf_copy-sqlite
%_bindir/bf_tar-sqlite
%_bindir/bogolexer-sqlite
%_bindir/bogotune-sqlite
%_bindir/bogoupgrade-sqlite
%_bindir/bogoutil-sqlite

%files contrib
%_datadir/%name

%files doc
%doc AUTHORS COPYING GETTING.STARTED NEWS README RELEASE.NOTES TODO
%doc doc/*.html doc/integrating-with-* doc/README.*

%changelog
