%define _unpackaged_files_terminate_build 1
%define soname 1
Name: blosc
Version: 1.21.6
Release: alt1
Summary: Blosc: A blocking, shuffling and lossless compression library
License: MIT
Group: System/Libraries
Url: https://www.blosc.org/
VCS: https://github.com/Blosc/c-blosc.git
Source: %name-%version.tar

BuildRequires: cmake gcc-c++ libsnappy-devel zlib-devel liblz4-devel libzstd-devel

%description
Blosc is a high performance compressor optimized for binary data. It has
been designed to transmit data to the processor cache faster than the
traditional, non-compressed, direct memory fetch approach via a memcpy()
OS call. Blosc is the first compressor (that I'm aware of) that is meant
not only to reduce the size of large datasets on-disk or in-memory, but
also to accelerate memory-bound computations.

%package -n lib%name
Summary: Blosc: A blocking, shuffling and lossless compression library
Group: System/Libraries

%description -n lib%name
Blosc is a high performance compressor optimized for binary data. It has
been designed to transmit data to the processor cache faster than the
traditional, non-compressed, direct memory fetch approach via a memcpy()
OS call. Blosc is the first compressor (that I'm aware of) that is meant
not only to reduce the size of large datasets on-disk or in-memory, but
also to accelerate memory-bound computations.

%package -n lib%name-devel
Summary: Development files of Blosc library
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
Blosc is a high performance compressor optimized for binary data. It has
been designed to transmit data to the processor cache faster than the
traditional, non-compressed, direct memory fetch approach via a memcpy()
OS call. Blosc is the first compressor (that I'm aware of) that is meant
not only to reduce the size of large datasets on-disk or in-memory, but
also to accelerate memory-bound computations.

This package contains development files of Blosc library.

%prep
%setup

# remove bundled libraries
rm -rf internal-complibs

%build
%cmake \
	-DBUILD_BENCHMARKS:BOOL=OFF \
	-DBUILD_TESTS:BOOL=OFF \
	-DBUILD_STATIC:BOOL=OFF \
	-DPREFER_EXTERNAL_LZ4:BOOL=ON \
	-DPREFER_EXTERNAL_SNAPPY:BOOL=ON \
	-DPREFER_EXTERNAL_ZLIB:BOOL=ON \
	-DPREFER_EXTERNAL_ZSTD:BOOL=ON \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files -n lib%name
%doc *.rst
%_libdir/libblosc.so.%soname
%_libdir/libblosc.so.%version

%files -n lib%name-devel
%_includedir/blosc.h
%_includedir/blosc-export.h
%_libdir/libblosc.so
%_pkgconfigdir/blosc.pc

%changelog
