%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed
%define git %nil
%define kern_dir scripts/addons_core/cycles/lib
%define project blender

%def_with docs

%ifarch aarch64 x86_64 %e2k
%def_with embree
%else
%def_without embree
%endif

%ifarch x86_64 aarch64
# HIP should work on other 64-bit arches but clr needs to get built first
%def_with hip
%else
%def_without hip
%endif

%ifarch x86_64
%def_with cuda
%def_with optix
%def_with hiprt
# oneapi needs dpcpp/sycl compiler
%def_with oneapi
%else
%def_without cuda
%def_without optix
%def_without hiprt
%def_without oneapi
%endif

%ifarch x86_64 aarch64
%def_with mold
%else
%def_without mold
%endif

%ifarch x86_64 aarch64
%def_with openpgl
%def_with usd
%def_with oidn
%def_with materialx
%else
%def_without openpgl
%def_without usd
%def_without oidn
%def_without materialx
%endif

%ifarch %e2k
# error: cpio archive too big - 4690M
%define optflags_debug -g0
%endif

# https://devtalk.blender.org/t/does-blender-use-jemalloc-and-or-tbb/13388/10
%def_with jemalloc

Name: %{project}4.5
Version: 4.5.5
Release: alt1
Summary: 3D modeling, animation, rendering and post-production
License: GPL-3.0-or-later
Group: Graphics
URL: https://www.blender.org
Vcs: https://projects.blender.org/blender/blender.git

# Blender doesn't officially support 32-bit build since 2.80. See also:
# https://developer.blender.org/T67184
ExcludeArch: %ix86

# https://projects.blender.org/blender/blender
Source: %name-%version.tar
# lfs assets needed for operation
# See https://projects.blender.org/blender/blender/issues/140443
Source1: lfs.tar

# scripts/modules/_bpy_internal/freedesktop.py#L247
# https://bugzilla.altlinux.org/55890
Source2: blender.thumbnailer

Patch21: blender-2.77-alt-enable-localization.patch
Patch22: blender-4.5.0-alt-include-deduplication-check-skip.patch
Patch23: blender-2.80-alt-use-system-glog.patch
Patch24: blender-2.90-alt-non-x86_64-linking.patch
# needed for static clang libs
Patch30: blender-alt-fix-clang-linking.patch
Patch31: blender-alt-osl-shader-dir.patch
# needed for dynamic clang libs
Patch32: blender-4.5.0-alt-use-libclang.patch
Patch33: blender-alt-cycles-aarch64-hip-cuda-fix.patch
# gfx900 needs -O1 on Linux too, otherwise it will fail
# https://github.com/ROCm/llvm-project/issues/58#issuecomment-2041433424
Patch34: blender-4.5.0-cycles-fix-hip-kernels.patch
# cycles: restore Vega support, let's keep it for a while
Patch35: blender-4.5.0-alt-cycles-restore-vega.patch
# use system libdraco.so.9 instead of bundled one
Patch36: blender-4.4-system-draco.patch
Patch37: blender-4.4-alt-hiprt-2.5.patch
Patch38: blender-4.4-alt-hiprt-optflags.patch
Patch41: blender-4.5.0-oneapi-add-arl.patch
Patch43: blender-4.5.0-alt-numpy-inc.patch
Patch44: blender-alt-optix-inc.patch
# https://gitlab.com/libeigen/eigen/-/issues/2850
# https://libeigen.gitlab.io/eigen/docs-nightly/TopicPreprocessorDirectives.html#TopicPreprocessorDirectivesAssertions
Patch45: blender-4.5.4-eigen-assert.patch

# e2k and loongarch64 are broken now
#Patch2000: blender-e2k-support.patch
#Patch3500: blender-4.1-loongarch64.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-filesystem-devel boost-locale-devel boost-wave-devel boost-python3-devel
BuildRequires: cmake gcc-c++
BuildRequires: ninja-build /proc
BuildRequires: libGLEW-devel libXi-devel
BuildRequires: libavdevice-devel libavformat-devel libavfilter-devel libswresample-devel
BuildRequires: libfftw3-devel >= 3.3.9 libjack-devel libopenal-devel libsndfile-devel
BuildRequires: libjpeg-devel pkgconfig(libopenjp2) libpng-devel libtiff-devel libswscale-devel libxml2-devel
BuildRequires: liblzo2-devel
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libopenimageio-devel
BuildRequires: libopencolorio-devel
BuildRequires: openexr-devel
BuildRequires: imath-devel
BuildRequires: libpugixml-devel
BuildRequires: libglog-devel libgflags-devel eigen3-devel
BuildRequires: libXxf86vm-devel libXrender-devel
BuildRequires: tbb-devel
BuildRequires: libfreetype-devel
# Remove following dependency when libopenjpeg2.0-devel is fixed
BuildRequires: openjpeg-tools2.0
BuildRequires: alembic-devel
BuildRequires: openvdb-devel libblosc-devel
BuildRequires: libgomp-devel
BuildRequires: libgmp-devel libgmpxx-devel
BuildRequires: libharu-devel
BuildRequires: libpotrace-devel
BuildRequires: openshadinglanguage-devel
BuildRequires: opensubdiv-devel
BuildRequires: libzstd-devel
BuildRequires: libepoxy-devel
BuildRequires: libwayland-egl-devel wayland-protocols libwayland-cursor-devel libxkbcommon-devel libdecor-devel
BuildRequires: libvulkan-devel libshaderc-devel
BuildRequires: libspnav-devel
BuildRequires: libwebp-devel
BuildRequires: pipewire-libs-devel
BuildRequires: libmanifold-devel libClipper2-devel libassimp-devel
%ifarch aarch64
BuildRequires: sse2neon-devel
%endif

%if_with embree
BuildRequires: embree-devel
%endif

%if_with jemalloc
BuildRequires: libjemalloc-devel
%endif

%if_with docs
BuildRequires: /usr/bin/doxygen
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme
%endif

%if_with hip
BuildRequires: hip-devel
%endif

%if_with hiprt
BuildRequires: hiprt-devel clang-rocm-devel
%endif

%if_with openpgl
BuildRequires: openpgl-devel
%endif

%if_with usd
BuildRequires: OpenUSD-devel
%endif

%if_with cuda
BuildRequires: nvidia-cuda-devel
# .cubin files are ELF files but we still don't know how
# to handle them.
%set_verify_elf_skiplist %_datadir/%project/*/%kern_dir/*.cubin
%endif

%if_with optix
BuildRequires: optix-devel
%endif

%if_with oidn
BuildRequires: openimagedenoise-devel
%endif

%if_with mold
BuildRequires: mold
%endif

%if_with materialx
BuildRequires: MaterialX-devel
%endif

%if_with oneapi
BuildRequires: libze-devel llvm-dpcpp-devel clang-dpcpp-devel
BuildRequires: clang-dpcpp-tools intel-ocloc libigc2
%filter_from_requires /libcycles_kernel_oneapi_aot\.so/d
%set_verify_elf_skiplist %_libdir/libcycles_kernel_oneapi_aot.so
%set_debuginfo_skiplist %_libdir/libcycles_kernel_oneapi_aot.so
%endif

%add_python3_path %_datadir/%project/scripts
%add_python3_req_skip _bpy
%add_python3_req_skip _bpy_path
%add_python3_req_skip _cycles
%add_python3_req_skip _freestyle
%add_python3_req_skip bgl
%add_python3_req_skip blend
%add_python3_req_skip blf
%add_python3_req_skip idprop.types
%add_python3_req_skip gpu
%add_python3_req_skip io_scene_gltf2.blender.com
%add_python3_req_skip io_scene_gltf2.blender.exp
%add_python3_req_skip io_scene_gltf2.io.com
%add_python3_req_skip io_scene_gltf2.io.exp
%add_python3_req_skip mathutils
%add_python3_req_skip mathutils.bvhtree
%add_python3_req_skip mathutils.geometry
%add_python3_req_skip mathutils.noise
%add_python3_req_skip oscurart_tools.files
%add_python3_req_skip oscurart_tools.mesh
%add_python3_req_skip oscurart_tools.object
%add_python3_req_skip oscurart_tools.render
%add_python3_req_skip setuptools
%add_python3_req_skip bmesh
%add_python3_req_skip bpy.app.handlers
%add_python3_req_skip bpy.app.translations
%add_python3_req_skip bpy.props
%add_python3_req_skip bpy.types

# scripts/addons_core/io_scene_gltf2/blender/imp/draco.py
Requires: libdraco

AutoProv: no

Obsoletes: %project-i18n, %{project}4.4
Conflicts: %project <= %EVR

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%package doc
Summary: Documentation for Blender
Group: Documentation
Requires: %name = %EVR
Obsoletes: %{project}4.4-doc
Conflicts: %project-doc <= %EVR

%description doc
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation.

This package contains documentation for Blender.

%description doc -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

Данный пакет содержит документацию для Blender.

%if_with hip
%package cycles-hip-kernels
Summary: Cycles precompiled binaries for HIP
Group: System/Libraries
Requires: %name = %EVR, hip-runtime-amd
Obsoletes: %{project}4.4-cycles-hip-kernels
Conflicts: %project-cycles-hip-kernels

%description cycles-hip-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for AMD GPUs to use with HIP.
%endif

%if_with hiprt
%package cycles-hiprt-kernels
Summary: Cycles precompiled binaries for HIPRT
Group: System/Libraries
Requires: %name = %EVR, hip-runtime-amd
# due hardcoded dependency in hiprtew
Requires: libhiprt >= 2.5-alt2.4e650d5
Obsoletes: %{project}4.4-cycles-hiprt-kernels
Conflicts: %project-cycles-hip-kernels

%description cycles-hiprt-kernels
Precompiled GPU kernels for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for AMD GPUs to use with HIPRT.
%endif

%if_with cuda
%package cycles-cuda-kernels
Summary: Cycles precompiled binaries for CUDA
Group: System/Libraries
Requires: %name = %EVR, libcuda
Obsoletes: %{project}4.4-cycles-nvidia-kernels, %{project}4.5-cycles-nvidia-kernels
Conflicts: %project-cycles-cuda-kernels

%description cycles-cuda-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for Nvidia GPUs to use with CUDA.
%endif

%if_with optix
%package cycles-optix-kernels
Summary: Cycles precompiled binaries for OptiX
Group: System/Libraries
Requires: %name = %EVR, libnvoptix

%description cycles-optix-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for Nvidia GPUs to use with OptiX.
%endif

%prep
%setup -a1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
#%%patch30 -p1
%patch31 -p1
#%%patch32 -p1
%ifarch aarch64
# see https://github.com/OE4T/meta-tegra/pull/1445
%patch33 -p1
mkdir -p /tmp/bits
cat >/tmp/bits/math-vector.h <<EOF
#include <bits/libm-simd-decl-stubs.h>
#undef __ADVSIMD_VEC_MATH_SUPPORTED
#undef __SVE_VEC_MATH_SUPPORTED
EOF
%endif
%patch34 -p1 -b .hip-kernels-fixes
%patch35 -p1 -b .cycles-restore-vega
%patch36 -p1
%if_with hiprt
%patch37 -p1
%patch38 -p1
%endif
%patch41 -p1
%patch43 -p1
%patch44 -p1 -b .optix-inc
%patch45 -p1 -b .eigen-assert

%ifarch %e2k
#%%patch2000 -p1
# lcc 1.25.15's EDG bug would fail building OPENVDB+TBB otherwise
sed -i "/-Werror=return-type/d" CMakeLists.txt
sed -i 's/"${CMAKE_C_COMPILER_VERSION}" VERSION_LESS/"100" VERSION_LESS/' CMakeLists.txt
%endif
%ifarch loongarch64
#%%patch3500 -p1
%endif

# Delete the bundled FindOpenJPEG to make find_package use the system version
# instead (the local version hardcodes the openjpeg version so it is not update
# proof)
rm -f build_files/cmake/Modules/FindOpenJPEG.cmake

# Remove bundled libraries which must not be used instead of system ones
rm -rf extern/{Eigen3,glew,lzo,gflags,glog,draco}

# Explicitly use python3 in hashbangs.
pushd scripts/addons_core
subst '/^#!.*python$/s|python$|python3|' $(grep -Rl '#!.*python$' *)
popd

%build
BUILD_DATE="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%Y-%%m-%%d')"
BUILD_TIME="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%H:%%M:%%S')"

%add_optflags -DGLOG_USE_GLOG_EXPORT
%if_with hiprt
export ALTWRAP_LLVM_VERSION=rocm
%endif
%cmake -G Ninja \
%if_with hip
	-DWITH_CYCLES_HIP_BINARIES:BOOL=ON \
%endif #hip
%if_with cuda
	-DWITH_CYCLES_CUDA_BINARIES:BOOL=ON \
%endif #cuda
%if_with hiprt
	-DHIPRT_ROOT_DIR=%prefix \
	-DWITH_CYCLES_DEVICE_HIPRT:BOOL=ON \
	-DHIPRT_INCLUDE_DIR=%_includedir \
	-DHIP_LINKER_EXECUTABLE=%_bindir/clang++-rocm \
	-DHIPRT_COMPILER_PARALLEL_JOBS=4 \
%endif #hiprt
%if_with oneapi
	-DLEVEL_ZERO_ROOT_DIR=%prefix \
	-DSYCL_ROOT_DIR=%prefix/lib/llvm-dpcpp \
	-DWITH_CYCLES_DEVICE_ONEAPI:BOOL=ON \
	-DWITH_CYCLES_ONEAPI_BINARIES:BOOL=ON \
	-DOCLOC_INSTALL_DIR=%prefix \
	-DSYCL_OFFLINE_COMPILER_PARALLEL_JOB=2 \
%endif #oneapi
	-DBUILD_SHARED_LIBS=OFF \
	-DWITH_ALEMBIC:BOOL=ON \
	-DWITH_FFTW3=ON \
	-DWITH_JACK=ON \
	-DWITH_CODEC_SNDFILE=ON \
	-DWITH_IMAGE_OPENJPEG=ON \
	-DWITH_PYTHON=ON \
	-DWITH_PYTHON_INSTALL=OFF \
	-DWITH_CODEC_FFMPEG=ON \
	-DWITH_CXX_GUARDEDALLOC=OFF \
	-DWITH_INSTALL_PORTABLE=OFF \
	-DWITH_PYTHON_SAFETY=OFF \
	-DWITH_OPENMP=ON \
	-DWITH_CYCLES=ON \
%if_with embree
	-DEMBREE_ROOT_DIR=%_prefix \
	-DWITH_CYCLES_EMBREE:BOOL=ON \
%else
	-DWITH_CYCLES_EMBREE:BOOL=OFF \
%endif
%if_with usd
	-DWITH_USD:BOOL=ON \
%else
	-DWITH_USD:BOOL=OFF \
%endif
%if_with materialx
	-DWITH_MATERIALX:BOOL=ON \
%else
	-DWITH_MATERIALX:BOOL=OFF \
%endif
%if_with mold
	-DWITH_LINKER_MOLD=YES \
%endif
	-DWITH_OPENCOLORIO=ON \
	-DWITH_OPENVDB:BOOL=ON \
	-DWITH_OPENVDB_BLOSC:BOOL=ON \
	-DWITH_SYSTEM_LZO=ON \
	-DWITH_SYSTEM_EIGEN3:BOOL=ON \
	-DWITH_SYSTEM_GFLAGS:BOOL=ON \
	-DWITH_SYSTEM_GLOG:BOOL=ON \
	-DWITH_SYSTEM_FREETYPE:BOOL=ON \
	-DWITH_SYSTEM_DRACO:BOOL=ON \
	-DWITH_IMAGE_OPENEXR=ON \
	-DWITH_TBB:BOOL=ON \
	-DPYTHON_VERSION="%_python3_version" \
	-DBUILDINFO_OVERRIDE_DATE="$BUILD_DATE" \
	-DBUILDINFO_OVERRIDE_TIME="$BUILD_TIME" \
	-DWITH_DOC_MANPAGE:BOOL=ON \
	-DWITH_ASSERT_ABORT:BOOL=OFF \
	-DWITH_LINKER_GOLD:BOOL=OFF \
	-DWITH_OPENSUBDIV:BOOL=ON \
	-DOPENEXR_INCLUDE_DIRS=%_includedir/OpenEXR \
	%nil

ninja-build -v -j %__nprocs -C %_cmake__builddir

%if_with docs
pushd doc/doxygen
doxygen -u Doxyfile
doxygen
popd
%endif

%install
# oneapi needs special handling
%if_with oneapi
install -pD -m644 %_cmake__builddir/intern/cycles/kernel/libcycles_kernel_oneapi_aot.so %buildroot%_libdir/libcycles_kernel_oneapi_aot.so
LD_LIBRARY_PATH=%buildroot%_libdir \
doc/manpage/blender.1.py --blender %_cmake__builddir/bin/blender --output %_cmake__builddir/source/creator/blender.1
%cmake_install
rm -f %buildroot%_datadir/%project/lib/libcycles_kernel_oneapi_aot.so
%else
%cmake_install
%endif
install -pD -m644 %SOURCE2 %buildroot%_datadir/thumbnailers/%project.thumbnailer

%files
%_bindir/*
%_desktopdir/%project.desktop
%_iconsdir/hicolor/scalable/apps/%project.svg
%_iconsdir/hicolor/symbolic/apps/%project-symbolic.svg
%_datadir/%project/
%_datadir/thumbnailers/%project.thumbnailer
%if_with hip
%exclude %_datadir/%project/*/%kern_dir/kernel_gfx*.fatbin*
%endif
%if_with hiprt
%exclude %_datadir/%project/*/%kern_dir/kernel_rt_gfx*.hipfb*
%endif
%if_with cuda
%exclude %_datadir/%project/*/%kern_dir/kernel_compute*.ptx*
%exclude %_datadir/%project/*/%kern_dir/kernel_sm_*.cubin*
%endif
%if_with optix
%exclude %_datadir/%project/*/%kern_dir/kernel_optix*.ptx*
%endif
%if_with oneapi
%_libdir/libcycles_kernel_oneapi_aot.so*
%endif
%_datadir/metainfo/*.metainfo.xml
%_defaultdocdir/%project/
%_man1dir/%project.1*

%if_with hip
%files cycles-hip-kernels
%_datadir/%project/*/%kern_dir/kernel_gfx*.fatbin*
%endif

%if_with hiprt
%files cycles-hiprt-kernels
%_datadir/%project/*/%kern_dir/kernel_rt_gfx*.hipfb*
%endif

%if_with cuda
%files cycles-cuda-kernels
%_datadir/%project/*/%kern_dir/kernel_compute*.ptx*
%_datadir/%project/*/%kern_dir/kernel_sm_*.cubin*
%endif

%if_with optix
%files cycles-optix-kernels
%_datadir/%project/*/%kern_dir/kernel_optix*.ptx*
%endif

%if_with docs
%files doc
%doc doc/doxygen/html
%endif

%changelog
