%define import_path github.com/siderolabs/bldr
%define sha 086a6b4
%define tag v%version

Name: bldr
Version: 0.5.5
Release: alt1
Summary: Tool to build and package software distributions

Group: Development/Tools
License: MPL-2.0

Url: https://github.com/siderolabs/bldr
Vcs: https://github.com/siderolabs/bldr.git

Source0: %name-%version.tar
Source1: %name-%version-vendor.tar

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang > 1.23.4 
BuildRequires: /proc

%description
bldr is a tool to build and package software distributions.
Build processruns in buildkit(or docker buildx),
build result can be exported as container image.

%prep
%setup -a1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export LDFLAGS="-X %import_path/internal/version.Name=bldr \
                -X %import_path/internal/version.SHA=%sha \
                -X %import_path/internal/version.Tag=%tag"

%golang_prepare

%golang_build cmd/bldr

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install

mkdir -p \
    %buildroot%_datadir/bash-completion/completions \
    %buildroot%_datadir/zsh/site-functions \
    %buildroot%_datadir/fish/vendor_completions.d

%buildroot%_bindir/bldr completion bash > %buildroot%_datadir/bash-completion/completions/bldr
%buildroot%_bindir/bldr completion zsh > %buildroot%_datadir/zsh/site-functions/_bldr
%buildroot%_bindir/bldr completion fish > %buildroot%_datadir/fish/vendor_completions.d/bldr


%files
%_bindir/bldr
%_datadir/bash-completion/completions/bldr
%_datadir/zsh/site-functions/_bldr
%_datadir/fish/vendor_completions.d/bldr
%doc *.md

%changelog
