Name: blackmagic
Version: 2.0.0
Release: alt1

Summary: In-application debugging tool for embedded microprocessors
License: GPLv3
Group: Development/Other
Url: https://black-magic.org/
VCS: https://github.com/blacksphere/blackmagic

Source0: %name-%version-%release.tar

BuildRequires: meson
BuildRequires: pkgconfig(hidapi-libusb)
BuildRequires: pkgconfig(libftdi1)
BuildRequires: pkgconfig(libusb-1.0)

%description
The Black Magic Probe is a modern, in-application debugging tool for embedded
microprocessors. It allows you see what is going on 'inside' an application
running on an embedded microprocessor while it executes. It is able to control
and examine the state of the target microprocessor using a JTAG or Serial Wire
Debugging (SWD) port and on-chip debug logic provided by the microprocessor.
The probe connects to a host computer using a standard USB interface. The user
is able to control exactly what happens using the GNU source level debugging
software, GDB.

%prep
%setup
echo '#define FIRMWARE_VERSION "%version-%release"' > src/include/version.h

%build
%meson
%meson_build
cp -pv src/platforms/hosted/README.md README.hosted.md

%install
install -pm0755 -D %_target_platform/blackmagic %buildroot%_bindir/blackmagic
install -pm0644 -D driver/99-blackmagic.rules %buildroot%_udevrulesdir/60-blackmagic.rules

%files
%doc COPYING* README* UsingSWO* UsingRTT*
%_udevrulesdir/60-blackmagic.rules
%_bindir/blackmagic

%changelog
