%define _unpackaged_files_terminate_build 1
%define bind_version 9.16.34

%define restart_flag /run/named/named.restart

Name: bind-dyndb-ldap
Version: 11.11
Release: alt1

Summary: LDAP back-end plug-in for BIND
License: %gpl2plus
Group: System/Servers

URL: https://pagure.io/bind-dyndb-ldap 
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: bind-devel >= %bind_version
BuildRequires: libldap-devel
BuildRequires: libkrb5-devel
BuildRequires: libuuid-devel
BuildRequires: libsasl2-devel
BuildRequires: autoconf-archive

Requires: bind >= %bind_version

%description
This package provides an LDAP back-end plug-in for BIND. It features
support for dynamic updates and internal caching, to lift the load
off of your LDAP server.

%prep
%setup
%patch -p1

%build
%autoreconf
export BIND9_CFLAGS='-I/usr/include/bind9'
%configure
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_localstatedir/bind/zone/dyndb-ldap/

%pre
# upgrade

# Previously, during an upgrade transaction named failed on restart
# with binary incompatible dyndb plugin (not updated yet). So the
# special file-flag is created if named was running before upgrade.
# Later, named's filetrigger checks it for restart.
if [ "$1" -gt 1 ] && [ ! -f '%restart_flag' ]; then
    SYSTEMCTL=systemctl
    if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
        "$SYSTEMCTL" is-active bind.service >/dev/null 2>&1 &&
        "$SYSTEMCTL" stop bind.service 2>/dev/null &&
        mkdir -p "$(dirname '%restart_flag')" &&
        touch '%restart_flag' 2>/dev/null ||:
    else
        %_initdir/bind status >/dev/null 2>&1 &&
        %_initdir/bind stop 2>/dev/null &&
        mkdir -p "$(dirname '%restart_flag')" &&
        touch '%restart_flag' 2>/dev/null ||:
    fi
fi

%post
# The following sed script:
#   - scopes the named.conf changes to dynamic-db
#   - replaces arg "name value" syntax with name "value"
#   - changes dynamic-db header to dyndb
#   - uses the new way the define path to the library
#   - removes no longer supported arguments (library, cache_ttl,
#       psearch, serial_autoincrement, zone_refresh)
while read -r PATTERN
do
    SEDSCRIPT+="$PATTERN"
done <<EOF
/^\s*dynamic-db/,/};/ {

  s/\(\s*\)arg\s\+\(["']\)\([a-zA-Z_]\+\s\)/\1\3\2/g;

  s/^dynamic-db/dyndb/;

  s@\(dyndb "[^"]\+"\)@\1 "%_libdir/bind/ldap.so"@;
  s@\(dyndb '[^']\+'\)@\1 '%_libdir/bind/ldap.so'@;

  /\s*library[^;]\+;/d;
  /\s*cache_ttl[^;]\+;/d;
  /\s*psearch[^;]\+;/d;
  /\s*serial_autoincrement[^;]\+;/d;
  /\s*zone_refresh[^;]\+;/d;
}
EOF

sed -i.bak --follow-symlinks -e "$SEDSCRIPT" /etc/named.conf

%files
%_defaultdocdir/%name
%_libdir/bind/ldap.so
%dir %attr(770, root, named) %_localstatedir/bind/zone/dyndb-ldap/

%exclude %_libdir/bind/*.la

%changelog
