%def_enable snapshot

%define _name gnome-notes
%define ver_major 41
%define beta .alpha
%define xdg_name org.gnome.Notes
%define _libexecdir %_prefix/libexec

Name: bijiben
Version: %ver_major
Release: alt0.3%beta

Summary: GNOME Notes
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Notes
Vcs: https://gitlab.gnome.org/GNOME/gnome-notes.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %_name-%version%beta.tar
%endif

Provides: %_name = %EVR
# to avoid conflict between webki2gtk{4.1,6.0}-debuginfo
%add_debuginfo_skiplist %_bindir/* %_libexecdir/*

%define glib_ver 2.68
%define gtk_ver 4.8
%define adw_ver 1.2
%define tracker_api_ver 3.0
%define tracker_ver 3.0
%define eds_ver 3.45.1
%define webkit_api_ver 6.0
%define webkit_ver 2.40

Requires: dconf tinysparql localsearch

BuildRequires(pre): rpm-macros-meson rpm-build-xdg
BuildRequires: meson yelp-tools
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(tracker-sparql-%tracker_api_ver) >= %tracker_ver
BuildRequires: libxml2-devel pkgconfig(webkitgtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: libgnome-online-accounts-devel libuuid-devel
BuildRequires: evolution-data-server-devel >= %eds_ver libcurl-devel
BuildRequires: libical-devel libicu-devel libjson-glib-devel

%description
GNOME Notes (Bijiben) is a simple application for creating, editing and
viewing notes.

%prep
%setup -n %_name-%version%beta

%build
%meson \
    -Dupdate_mimedb=false
# SMP-incompatible build
%meson_build -j 1

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-shell-search-provider
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_xdgmimedir/packages/%xdg_name.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* AUTHORS NEWS

%changelog
