%define _unpackaged_files_terminate_build 1
%def_with check

Name: beust-jcommander
Version: 3.0
Release: alt2

Summary: Java framework for parsing command line parameters
License: Apache-2.0
Group: Development/Java
Url: http://jcommander.org
Vcs: https://github.com/cbeust/jcommander.git
BuildArch: noarch

Source0: %name-%version.tar
Patch0: 0001-Unicode-fix-for-tests-with-java-11.patch
Patch1: 0002-Disable-signing-with-key.patch
Patch2: 0003-Port-to-Java-11-alt-patch.patch
# Banner templates are not allowed in Java 11.
%if_with check
Patch3: 0004-Port-to-Java-11-for-tests-alt-patch.patch
%endif

BuildRequires(pre): rpm-macros-gradle
BuildRequires: /proc
BuildRequires: jpackage-17-compat
BuildRequires: xgradle
BuildRequires: rpm-build-java-osgi
BuildRequires: biz-aQute-bnd-gradle-plugins
BuildRequires: jackson-core
BuildRequires: jackson-annotations
BuildRequires: testng

Provides: mvn(com.beust:jcommander) = %EVR
Provides: mvn(org.jcommander:jcommander) = %EVR

%description
JCommander is a very small Java framework that makes it trivial to
parse command line parameters (with annotations).

%package javadoc
Group: Development/Java
Summary: API documentation for %name
BuildArch: noarch

%description javadoc
This package contains the %summary.

%prep
%setup
%autopatch -p1

# Change target compilation to Java 11 for compatibility with xmvn.
sed -i 's/JavaVersion\.VERSION_17/JavaVersion.VERSION_11/g' build.gradle.kts

%build
%gradle_publish

%install
# Alias for backward compatibility (changed groupId).
%mvn_alias org.jcommander:jcommander com.beust:jcommander

%gradle_register
%gradle_register_javadoc

%gradle_install

%check
%gradle_check

%files -f .mfiles
%doc license.txt notice.md README.markdown

%files javadoc -f .mfiles-javadoc
%doc license.txt notice.md

%changelog
