Name: bcache-tools
Version: 1.1
Release: alt3
Epoch: 1

Summary: Tools for Linux kernel block layer cache
License: GPLv2
Group: System/Kernel and hardware
Url: http://bcache.evilpiepirate.org/

#git://git.kernel.org/pub/scm/linux/kernel/git/colyli/bcache-tools.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: pkgconfig(blkid)
BuildRequires: pkgconfig(uuid)

%package -n bcache-status
Summary: Display useful bcache statistics
Group: System/Kernel and hardware
Requires: %name
BuildArch: noarch

%description
Bcache is a Linux kernel block layer cache. It allows one or more fast disk
drives such as flash-based solid state drives (SSDs) to act as a cache for
one or more slower hard disk drives.
This package contains the utilities for manipulating bcache.

%description -n bcache-status
Display useful bcache statistics

%prep
%setup

%build
%make_build

%install
%make_install DESTDIR=%buildroot install

%files
%doc README COPYING
%_udevdir/bcache-export-cached
%_udevdir/bcache-register
%_udevdir/probe-bcache
%_udevrulesdir/*.rules

%_sbindir/bcache
%_sbindir/bcache-super-show
%_sbindir/make-bcache

%_man8dir/bcache-super-show.*
%_man8dir/make-bcache.*
%_man8dir/probe-bcache.*

%files -n bcache-status
%_sbindir/bcache-status
%_man8dir/bcache-status.8.*

%changelog
