Name: bat
Version: 0.26.0
Release: alt1
Summary: A cat(1) clone with syntax highlighting and Git integration
License: MIT or Apache-2.0
Group: File tools
Url: https://crates.io/crates/bat
VCS: https://github.com/sharkdp/bat

Source: %name-%version.tar
Source1: vendor.tar

BuildRequires(pre): rpm-macros-rust
BuildRequires: rpm-build-rust

Conflicts: bacula9-bat
Conflicts: bacula11-bat
Conflicts: bacula13-bat
Conflicts: bacula15-bat

%ifarch i586 armh
%filter_from_requires /libc.so.6(GLIBC_PRIVATE)/d
%endif

%description
A cat(1) clone which supports syntax highlighting for a large number of
programming and markup languages. It has git integration and automatic paging.

%prep
%setup -a 1
%rust_prep

%build
%rust_build

%install
%rust_install
mkdir -p %buildroot%_man1dir
install -m 0644 target/release/build/%name-*/out/assets/manual/%name.1 %buildroot%_man1dir
install -Dm 0644 target/release/build/%name-*/out/assets/completions/bat.bash %buildroot%_datadir/bash-completion/completions/bat
install -Dm 0644 target/release/build/%name-*/out/assets/completions/bat.zsh %buildroot%_datadir/zsh/site-functions/_bat
install -Dm 0644 target/release/build/%name-*/out/assets/completions/bat.fish %buildroot%_datadir/fish/vendor_completions.d/bat.fish

%check
# Test no_args_doesnt_break failed in hasher with error "Couldn't open pty"
cargo test -- --skip no_args_doesnt_break

%files
%_bindir/%name
%_man1dir/%name.1.xz
%_datadir/bash-completion/completions/bat
%_datadir/zsh/site-functions/_bat
%_datadir/fish/vendor_completions.d/bat.fish
%doc README.md LICENSE-MIT LICENSE-APACHE

%changelog
