%define _unpackaged_files_terminate_build 1

%define _libexecdir %_prefix/libexec

Name: ayatana-indicator-session
Version: 24.5.1
Release: alt2

Summary: Ayatana Indicator showing session management, status and user switching
License: GPLv3
Group: Graphical desktop/Other
Url: https://github.com/AyatanaIndicators/ayatana-indicator-session

Source: %name-%version.tar

# sync with version 24.5.1-2 from Debian unstable
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd

BuildRequires: ayatana-cmake-modules
BuildRequires: ayatana-indicator-common
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: hicolor-icon-theme
BuildRequires: intltool
BuildRequires: libayatana-common-devel
BuildRequires: libblkid-devel
BuildRequires: libmount-devel
BuildRequires: libpcre2-devel
BuildRequires: libpcre-devel
BuildRequires: libselinux-devel
BuildRequires: libsystemd-devel
BuildRequires: zlib-devel

%description
This indicator is designed to be placed on the right side of a
panel and give the user easy control for changing their instant
message status. Switching to another user. Starting a guest
session. Or controlling the status of their own session.

It requires some way to be hosted into a panel. For the MATE Panel
the appropriate package is mate-indicator-applet.

%prep
%setup
%patch -p1

%build
%cmake \
  -Denable_tests=Off \
  -DENABLE_RDA=Off
%cmake_build

%install
%cmake_install

# these translations are ignored by %%find_lang
rm -fv %buildroot%_datadir/locale/it_CARES/LC_MESSAGES/%name.mo
rm -fv %buildroot%_datadir/locale/zh_LATN@pinyin/LC_MESSAGES/%name.mo

%find_lang %name

%post
%systemd_user_post %name.service

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun %name.service

%files -f %name.lang
%doc COPYING NEWS README
%config %_sysconfdir/xdg/autostart/%name.desktop
%dir %_libexecdir/%name/
%_libexecdir/%name/%{name}-service
%_iconsdir/*/*/*/*
%_datadir/glib-2.0/schemas/org.ayatana.indicator.session.gschema.xml
%_datadir/ayatana/indicators/org.ayatana.indicator.session
%_userunitdir/%name.service

%changelog
