%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

Name: ayatana-indicator-display
Version: 24.5.2
Release: alt1

Summary: Ayatana Indicator for Display configuration
License: GPLv3
Group: Graphical desktop/Other
Url: https://github.com/AyatanaIndicators/ayatana-indicator-display

Source: %name-%version.tar

ExcludeArch: ppc64le

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd

BuildRequires: ayatana-cmake-modules
BuildRequires: ayatana-indicator-common
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: intltool
BuildRequires: libaccountsservice-devel
BuildRequires: libayatana-common-devel
BuildRequires: libblkid-devel
BuildRequires: libgeoclue2-devel
BuildRequires: libgudev-devel
BuildRequires: libmount-devel
BuildRequires: libpcre2-devel
BuildRequires: libpcre-devel
BuildRequires: libselinux-devel
BuildRequires: libsystemd-devel
BuildRequires: pkg-config
BuildRequires: properties-cpp-devel
BuildRequires: zlib-devel
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xrandr)

Requires: xsct

%description
This Ayatana Indicator is designed to be placed on the right side
of a panel and give the user easy control for changing their
display settings.

Ayatana Indicators are only available on desktop environments that
provide a renderer for system indicators (such as MATE, Xfce, Lomiri,
etc.).

%prep
%setup

%build
%cmake \
  -Denable_lomiri_features=Off \
  -Denable_tests=OFF \
  -DENABLE_RDA=OFF
%cmake_build

%install
%cmake_install

find %buildroot -type 'f' -name '*.la' -delete -print

# these translations are ignored by %%find_lang
rm -fv %buildroot%_datadir/locale/it_CARES/LC_MESSAGES/%name.mo
rm -fv %buildroot%_datadir/locale/zh_LATN@pinyin/LC_MESSAGES/%name.mo

%find_lang %name

%post
%systemd_user_post %name.service

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun %name.service

%files -f %name.lang
%doc COPYING AUTHORS INSTALL.md NEWS README README.md
%config %_sysconfdir/xdg/autostart/%name.desktop
%dir %_libexecdir/%name/
%_libexecdir/%name/%{name}-service
%_datadir/glib-2.0/schemas/org.ayatana.indicator.display.gschema.xml
%_datadir/ayatana/indicators/org.ayatana.indicator.display
%_iconsdir/hicolor/scalable/status/*.svg
%_datadir/dbus-1/interfaces/org.ayatana.indicator.display.AccountsService.xml
%_userunitdir/%name.service
%_datadir/accountsservice/interfaces/org.ayatana.indicator.display.AccountsService.xml
%_datadir/polkit-1/actions/org.ayatana.indicator.display.AccountsService.policy
%_datadir/polkit-1/rules.d/50-org.ayatana.indicator.display.AccountsService.rules

%changelog
