%define  nomen awesome
Name: %nomen
Version: 4.3
Release: alt6
Group: Graphical desktop/Other
License: %gpl2plus

Url: https://awesomewm.org/
Source: %name-%version.tar
Source1: %name.wmsession
Source2: %name.menu-method
Patch0:%name-%version-alt.patch
Patch1:cmakefile.patch
Summary: A window manager initialy based on a dwm code rewriting

BuildRequires: ImageMagick-tools asciidoctor cmake gcc-c++ gperf
BuildRequires: imlib2-devel libdbus-devel libev-devel liblua5.3-devel
BuildRequires: libncurses-devel libpango-devel libreadline-devel xmlto
BuildRequires: libxdg-basedir-devel libstartup-notification-devel
BuildRequires: libXdmcp-devel libgdk-pixbuf-devel lgi
BuildRequires: lua5.3 libpango-gir libgdk-pixbuf-gir libcairo-gobject
BuildRequires: libpcre-devel libxkbcommon-devel libxkbcommon-x11-devel libxcbutil-xrm-devel

BuildRequires: libxcbutil-devel >= 0.3.8 libxcbutil-keysyms-devel >= 0.3.8
BuildRequires: libxcbutil-icccm-devel >= 0.3.8 libxcbutil-cursor-devel
BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-build-lua
BuildRequires: libsystemd-devel
BuildRequires: libpcre2-devel

Requires: libstartup-notification >= 0.10-alt1
Requires: lgi >= 0.9.1
Requires: libpango-gir
Requires: libcairo-gobject
Requires: libgdk-pixbuf-gir

%filter_from_requires /lua.*\(awful.*\|beautiful\|gears\|menubar\|naughty\|wibox\|menu\|lgi\)/d

%description
awesome is a window manager initialy based on a dwm code rewriting. It's
extremely fast, small, dynamic and awesome.

%prep
%setup -n %name-%version
%patch0 -p1
%patch1

%build
%cmake \
   -DCMAKE_BUILD_TYPE=RelWithDebInfo \
   -DCOMPRESS_MANPAGES=OFF \
   -DXDG_CONFIG_DIR=%_xdgconfigdir \
   %nil
%cmake_build

%install
%cmake_install

mkdir -p %buildroot%_sysconfdir/xdg/%name/
install -D -m 644 %name.desktop %buildroot/%_desktopdir/%name.desktop
touch %buildroot%_sysconfdir/xdg/%name/menu.lua
install -D -m 644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/05%name
install -D -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%name

%find_lang %name

%files -f %name.lang
%_bindir/*
%_sysconfdir/menu-methods/%name
%_sysconfdir/xdg/%name
%config(noreplace) %_xdgconfigdir/%nomen/rc.lua
%config(noreplace) %_xdgconfigdir/%nomen/menu.lua
%_sysconfdir/X11/wmsession.d/*
%_man1dir/aw*
%_man5dir/aw*
%_mandir/*/man1/aw*
%_mandir/*/man5/aw*
%_datadir/%name
%_desktopdir/%name.desktop
%_datadir/xsessions/%name.desktop
%_defaultdocdir/%nomen
%doc LICENSE README.md

%changelog
