%def_disable check

%define realname autoconf
%define dialect _2.72
%define suff -2.72

Name: %realname%dialect
Version: 2.72
Release: alt2

Summary: A GNU tool for automatically configuring source code
License: GPLv2+
Group: Development/Other
Url: https://www.gnu.org/software/%realname/
Vcs: https://git.savannah.gnu.org/git/autoconf.git
BuildArch: noarch

%set_compress_method xz
%define srcname %realname-%version-%release
%define __spec_autodep_custom_pre export autom4te_perllibdir=%buildroot%_datadir/%realname%suff

# git://git.altlinux.org/gears/a/autoconf_2.72.git
Source: %srcname.tar

Requires: autoconf-common
# GNU m4 version 1.4.6 or later is required; 1.4.14 or later is recommended.
Requires: m4 >= 1.4.14
# portable mktemp, later obsoleted by coreutils.
Requires: coreutils
# due to config.guess.1 and config.sub.1
Requires: gnu-config >= 1.0.971.ff53

BuildRequires: help2man, makeinfo
%{!?__buildreqs:%{!?_without_check:%{!?_disable_check:BuildRequires: gcc-c++ gcc-g77 libgomp-devel}}}

%description
GNU's Autoconf is a tool for configuring source code and Makefiles.
Using Autoconf, programmers can create portable and configurable
packages, since the person building the package is allowed to
specify various configuration options.

You should install Autoconf if you are developing software and you'd
like to use it to create shell scripts which will configure your
source code packages.  If you are installing Autoconf, you will also
need to install the GNU m4 package.

Note that the Autoconf package is not required for the end user who
may be configuring software with an Autoconf-generated script;
Autoconf is only required for the generation of the scripts, not
their use.

%prep
%setup -n %srcname
find -type f -print0 |
	xargs -r0 fgrep -lZ @RPM_AUTOCONF_SUFFIX@ -- |
	xargs -r0 sed -i s,@RPM_AUTOCONF_SUFFIX@,%suff, --

find -type f -print0 |
	xargs -r0 grep -FZl 'mawk gawk' -- |
	xargs -r0 sed -i 's/mawk gawk/gawk mawk/g' --

# patch texinfo file
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1%suff\2(%realname%suff)/' \
	doc/autoconf.texi

# Build scripts expect to find autoconf version in this file.
echo -n %version > .tarball-version

%build
export ac_cv_prog_EMACS=no
autoreconf -iv
%configure --program-suffix=%suff
%make_build

%install
%makeinstall

# We don't want to include the standards.info stuff in the package,
# since it comes from binutils.
rm -f %buildroot%_infodir/standards*

# Some more helpful scripts.
rm -f %buildroot%_datadir/%realname/INSTALL
mv %buildroot%_datadir/%realname %buildroot%_datadir/%realname%suff

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

for f in %buildroot%_bindir/*%suff; do
	ln -s "${f##*/}" "${f%%%suff}%dialect"
done

%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff
%{?filter_from_requires:%filter_from_requires /^perl(Autom4te/d}
%{?filter_from_provides:%filter_from_provides /^perl(/d}

%check
%make_build -k check VERBOSE=1

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%_bindir/*
%_datadir/%realname%suff
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
