Name: augeas
Version: 1.14.1
Release: alt2
Summary: A library for changing configuration files

Group: System/Configuration/Other
License: LGPLv2+
Url: https://augeas.net/
Vcs: https://github.com/hercules-team/augeas
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: readline-devel libselinux-devel gnulib flex perl-podlators ruby-stdlibs libxml2-devel
# for tests
BuildRequires: /proc
Requires: vim-common

%description
A library for programmatically editing configuration files. Augeas parses
configuration files into a tree structure, which it exposes through its
public API. Changes made through the API are written back to the initially
read files.

The transformation works very hard to preserve comments and formatting
details. It is controlled by ``lens'' definitions that describe the file
format and the transformation into a tree.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n lib%name
Summary: Libraries for %name
Group: System/Libraries

%description -n lib%name
The libraries for %name.

%prep
%setup -q
%patch -p1

%build
./autogen.sh --gnulib-srcdir=/usr/share/gnulib
%configure --disable-static --disable-gnulib-tests
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/*
%_mandir/man1/*
%_datadir/bash-completion/completions/*
%_datadir/vim/vimfiles/syntax/augeas.vim
%_datadir/vim/vimfiles/ftdetect/augeas.vim

%files -n lib%name
%_datadir/augeas
%_libdir/*.so.*
%doc AUTHORS COPYING NEWS

%files -n lib%name-devel
%doc
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/augeas.pc

%changelog
