Name: atf-rockchip
Version: 2.14
Release: alt1

Summary: ARM Trusted Firmware
License: BSD
Group: System/Kernel and hardware

Conflicts: rk35-firmware < 20241023-alt3

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

Source: %name-%version-%release.tar
BuildRequires: dtc
BuildRequires: arm-none-eabi-gcc
BuildRequires: aarch64-none-elf-gcc

%description
ARM Trusted Firmware provides a reference implementation of secure world
software for ARMv8-A, including Exception Level 3 (EL3) software.
This package provides support for the RK3328, RK3399 and PX30 SoC families.

%prep
%setup

%build
export CROSS_COMPILE=aarch64-none-elf-
for plat in px30 rk3328 rk3368 rk3399 rk3568 rk3576 rk3588; do
	make distclean
	make -j8 PLAT=$plat bl31
	install -pm0644 -D build/$plat/release/bl31/bl31.elf out/$plat/bl31.elf
done

%install
mkdir -p %buildroot%_datadir/atf
cp -a out/* %buildroot%_datadir/atf/

%set_verify_elf_method none

%files
%_datadir/atf/*

%changelog
