Name: atf-meson
Version: 2.14
Release: alt1

Summary: ARM Trusted Firmware
License: BSD
Group: System/Kernel and hardware

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

BuildRequires: aarch64-none-elf-gcc

Source: %name-%version-%release.tar

%description
ARM Trusted Firmware provides a reference implementation of secure world
software for ARMv8-A, including Exception Level 3 (EL3) software.
This release provides initial support for the AMLogic AXG, GXBB, GXL and
G12A SoC families.

%prep
%setup

%build
export CROSS_COMPILE=aarch64-none-elf-
for plat in gxbb; do
	make distclean
	make PLAT=$plat bl31
	install -pm0644 -D build/$plat/release/bl31.bin out/$plat/bl31.bin
done
for plat in axg g12a gxl; do
	make distclean
	make PLAT=$plat
	install -pm0644 -D build/$plat/release/bl31.img out/$plat/bl31.img
done

%install
mkdir -p %buildroot%_datadir/atf
cp -a out/* %buildroot%_datadir/atf/

%files
%_datadir/atf/*

%changelog
