%define _name at-spi2
%define ver_major 2.58
%define api_ver_major 2
%define api_ver 2.0
%define namespace Atspi
%define atk_api_ver 1.0

%define _libexecdir %_prefix/libexec
%def_enable introspection
%def_enable x11
%def_enable gtk2
%def_disable xevie
%def_enable doc
%def_enable systemd
%def_disable check

Name: %_name-core
Version: %ver_major.2
Release: alt1

Summary: Protocol definitions and daemon for D-Bus at-spi
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Accessibility

Vcs: https://gitlab.gnome.org/GNOME/at-spi2-core.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: lib%name = %EVR
Requires: dbus-tools-gui
# /etc/xdg/Xwayland-session.d/00-at-spi uses busctl from systemd
#%%filter_from_requires /^systemd/d

%define meson_ver 0.63
%define glib_ver 2.67.4
%define dbus_ver 1.5

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-xdg rpm-build-python3
BuildRequires: meson >= %meson_ver libgio-devel >= %glib_ver
BuildRequires: /usr/bin/dbus-daemon libdbus-devel >= %dbus_ver
BuildRequires: libxml2-devel pkgconfig(libei-1.0) pkgconfig(xkbcommon)
%{?_enable_systemd:BuildRequires:pkgconfig(systemd)}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_x11:BuildRequires: libXtst-devel libXext-devel libXi-devel libICE-devel libSM-devel}
%{?_enable_xevie:BuildRequires: libXevie-devel}
%{?_enable_doc:BuildRequires: /usr/bin/sphinx-build-3 python3-module-sphinx_rtd_theme gi-docgen}

%description
The Access Technology Service Provider Interface (AT-SPI) is a set of
interfaces that allow access technologies such as screen readers to
programmatically determine what is being displayed on the screen and
simulate keyboard and mouse events. It can also be used for automated
testing.

The at-spi2-core module contains the D-Bus specification, the registry
daemon, and a C library for use by access technologies that provides a
convenient wrapper around the DBus interfaces.

%package -n lib%name
Summary: Shared at-spi library
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run at-spi daemon.

%package -n lib%name-devel
Summary: Development files and headers for at-spi2-core
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package includes the header files and API documentation for
libatspi.

%package -n lib%name-gir
Summary: GObject introspection data for at-spi2-core
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for at-spi library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for at-spi2-core
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %version-%release
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the at-spi library.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation for developing applications that use
%name library.

%package -n libatk
Summary: Shared ATK library
Group: System/Libraries

%description -n libatk
ATK is a library providing interface definitions that are consumed by
toolkits that wish to integrate with the GNOME accessibility
infrastructure.

This package provides shared ATK library.

%package -n libatk-devel
Summary: Development environment for ATK
Group: Development/C
Requires: libatk = %EVR

%description -n libatk-devel
ATK is a library providing interface definitions that are consumed by
toolkits that wish to integrate with the GNOME accessibility
infrastructure.

This package contains the necessary components to develop for ATK.

%package -n libatk-devel-doc
Summary: Development documentation for ATK
Group: Development/C
BuildArch: noarch
Conflicts: libatk < %version-%release

%description -n libatk-devel-doc
ATK is a library providing interface definitions that are consumed by
toolkits that wish to integrate with the GNOME accessibility
infrastructure.

This package contains development documentation for ATK.

%package -n libatk-gir
Summary: GObject introspection data for the Atk library
Group: System/Libraries
Requires: libatk = %EVR

%description -n libatk-gir
GObject introspection data for the Atk library

%package -n libatk-gir-devel
Summary: GObject introspection devel data for the Atk library
Group: Development/Other
BuildArch: noarch
Requires: libatk-devel = %EVR
Requires: libatk-gir = %EVR

%description -n libatk-gir-devel
GObject introspection devel data for the Atk library.

%package -n %_name-atk
Summary: Shared at-spi library
Group: System/Libraries
Requires: libatk = %EVR
Requires: lib%name = %EVR

%description -n %_name-atk
at-spi2-atk is the library used to bridge ATK to AT-SPI, allowing
applications exposing information via ATK to interface with clients that
use AT-SPI. This module provides the necessary inter-process
communication to allow accessibility-oriented software to operate.

This package contains shared library needed to run at-spi daemon.

%package -n %_name-atk-devel
Summary: Development files for atk-bridge
Group: Development/C
Requires: %_name-atk = %EVR
Requires: lib%name-devel = %EVR

%description -n %_name-atk-devel
This package provides development files for atk-bridge library.

%prep
%setup
sed -i 's/\(sphinx-build\)/\1-3/' devel-docs/meson.build

%build
%meson \
    -Ddbus_daemon=/bin/dbus-daemon \
    %{subst_enable_meson_feature x11 x11} \
    %{subst_enable_meson_bool gtk2 gtk2_atk_adaptor} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool systemd use_systemd} \
    %{subst_enable_meson_bool doc docs}
%nil
%meson_build
%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_xdgconfigdir/Xwayland-session.d/00-at-spi
%_libexecdir/at-spi2-registryd
%_libexecdir/at-spi-bus-launcher
%_datadir/dbus-1/accessibility-services/org.a11y.atspi.Registry.service
%_datadir/dbus-1/services/org.a11y.Bus.service
%_datadir/defaults/at-spi2/accessibility.conf
%_sysconfdir/xdg/autostart/at-spi-dbus-bus.desktop
%{?_enable_systemd:%_userunitdir/at-spi-dbus-bus.service}
%python3_sitelibdir/gi/overrides/%namespace.py
%python3_sitelibdir/gi/overrides/__pycache__/*
%doc README* MAINTAINERS NEWS

%files -n lib%name
%_libdir/libatspi.so.*

%files -n lib%name-devel
%_libdir/libatspi.so
%_includedir/at-spi-%api_ver/
%_pkgconfigdir/atspi-%api_ver_major.pc

%files -n libatk
%_libdir/libatk-%atk_api_ver.so.*

%files -n libatk-devel
%_includedir/atk-%atk_api_ver/
%_libdir/libatk-%atk_api_ver.so
%_pkgconfigdir/atk.pc

%files -n %_name-atk
%_libdir/libatk-bridge-%api_ver.so.*
%{?_enable_gtk2:%_libdir/gtk-2.0/modules/libatk-bridge.so}
%_libdir/gnome-settings-daemon-3.0/gtk-modules/%_name-atk.desktop

%files -n %_name-atk-devel
%_includedir/%_name-atk/
%_libdir/libatk-bridge-%api_ver.so
%_pkgconfigdir/atk-bridge-%api_ver.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/%namespace-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/%namespace-%api_ver.gir

%files -n libatk-gir
%_typelibdir/Atk-%atk_api_ver.typelib

%files -n libatk-gir-devel
%_girdir/Atk-%atk_api_ver.gir
%endif

%if_enabled doc
%files -n lib%name-devel-doc
%_datadir/doc/libatspi/

%files -n libatk-devel-doc
%_datadir/doc/atk/
%endif

%changelog
