Name: arj
Version: 3.10.22
Release: alt9
Epoch: 1

Summary: An compressor and uncompressor for .arj format archive files
License: GPL
Group: Archiving/Compression

URL: http://arj.sourceforge.net
Source: http://testcase.newmail.ru/files/arj-%version.tar.gz
Patch0: http://ftp.debian.org/debian/pool/main/a/arj/arj_%version-6.diff.gz
Patch1: arj-3.10.22-custom-printf.patch
Patch2: arj-3.10.22-missing-protos.patch
Patch3: arj-3.10.22-safe_strcpy.patch
# Needed on e2k: lcc removes the static const variable even when
# optimization is disabled.
Patch4: arj-3.10.22-drop-static.patch

Patch5: CVE-2015-0556-security-traversal-symlink.patch
Patch6: CVE-2015-0557-security-traversal-dir.patch
Patch7: CVE-2015-2782-security-afl.patch


%description
The ARJ program is used to compress and uncompress .arj format archives.
The .arj format archive was mostly used on DOS machines.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%ifarch %e2k
%patch4 -p1
%endif
%patch5 -p1
%patch6 -p1
%patch7 -p1

for i in debian/patches/00*.patch; do
  patch -p1 < $i
done

# strcopy doesn't like overlapping
# for f in `egrep -lr 'strcpy\(([a-zA-Z0-9_]+), \1\+' *`; do
# sed -ri 's/strcpy\(([a-zA-Z0-9_]+), \1(\+[^(]*)\)/bcopy(\1\2, \1, strlen(\1\2)+1)/g' $f
# done

%build
cd gnu
autoconf
libtoolize --copy --force
%configure
cd ..

make prepare
# Parallel build OK thanks to Debian patch
%make_build

%install
%make_install DESTDIR=%buildroot install
install -pD -m 644 resource/rearj.cfg.example $RPM_BUILD_ROOT%_sysconfdir/rearj.cfg

%files
%_sysconfdir/*
%_bindir/*
%_libdir/arj
%_man1dir/*
%doc doc/*.txt resource/en/*.txt

%changelog
