Name: aria2
Version: 1.37.0
Release: alt1

Summary: aria2 - a simple utility for downloading files faster
License: GPLv2+ with exceptions
Group: Networking/File transfer
Url: http://aria2.sourceforge.net/
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version.tar.xz

# Automatically added by buildreq on Thu Mar 23 2006
BuildRequires: gcc-c++ libssl-devel libstdc++-devel
BuildRequires: bison
BuildRequires: cppunit-devel
BuildRequires: gettext libasprintf-devel
BuildRequires: libcares-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgnutls-devel libgnutls-openssl-devel
BuildRequires: libsqlite3-devel
BuildRequires: libxml2-devel
BuildRequires: zlib-devel


%description
aria2 is a download utility with resuming and segmented downloading.
Supported protocols are HTTP/HTTPS/FTP/BitTorrent. It also supports Metalink
version 3.0.

Currently it has following features:
- HTTP/HTTPS GET support
- HTTP Proxy support
- HTTP BASIC authentication support
- HTTP Proxy authentication support
- FTP support (active, passive mode)
- FTP through HTTP proxy (GET command or tunneling)
- Segmented download
- Cookie support
- It can run as a daemon process.
- BitTorrent protocol support with fast extension.
- Selective download in multi-file torrent
- Metalink version 3.0 support (HTTP/FTP/BitTorrent).
- Limiting download/upload speed

%prep
%setup -n %name-%version
#set_gcc_version 4.7


%build


%configure --enable-bittorrent \
           --enable-metalink \
           --enable-epoll\
           --disable-rpath \
           --with-gnutls \
           --with-libcares \
           --with-libxml2 \
           --with-openssl \
           --with-libz \
           --with-sqlite3


%make

%install
#mkdir -p %buildroot%_bindir
#__install -pD -m755 src/aria2c %buildroot%_bindir/aria2c

%makeinstall
%find_lang aria2 --all-name
#find_lang aria2 --with-man --all-name

ln -s aria2c  %buildroot%_bindir/%name

#sed -i -e '1 s/^/.\\" -*- mode: troff; coding: utf8 -*-\n/;' doc/manual-src/ru/_build/man/aria2c.1

bzip2 doc/manual-src/en/_build/man/aria2c.1
bzip2 doc/manual-src/ru/_build/man/aria2c.1
bzip2 doc/manual-src/pt/_build/man/aria2c.1
rm -f %buildroot%_man1dir/aria2c.1.bz2
install -pD -m644 doc/manual-src/en/_build/man/aria2c.1.bz2 %buildroot%_man1dir/aria2c.1.bz2
install -pD -m644 doc/manual-src/en/_build/man/aria2c.1.bz2 %buildroot%_mandir/en/man1/aria2c.1.bz2
install -pD -m644 doc/manual-src/ru/_build/man/aria2c.1.bz2 %buildroot%_mandir/ru/man1/aria2c.1.bz2
install -pD -m644 doc/manual-src/pt/_build/man/aria2c.1.bz2 %buildroot%_mandir/pt/man1/aria2c.1.bz2

mkdir %buildroot%_docdir/%name-%version
mv %buildroot%_docdir/aria2/* %buildroot%_docdir/%name-%version
#mkdir %buildroot%_docdir/%name-%version/bash_completion
#mv %buildroot%_docdir/aria2/bash_completion/* %buildroot%_docdir/%name-%version/bash_completion
#mkdir %buildroot%_docdir/%name-%version/xmlrpc
#mv %buildroot%_docdir/aria2/xmlrpc/* %buildroot%_docdir/%name-%version/xmlrpc


%files -f aria2.lang
#doc AUTHORS ChangeLog README*
%dir %_docdir/aria2-%version
%_bindir/%name
%_bindir/aria2c
%_man1dir/aria2c.1.bz2
%_mandir/*/man1/aria2c.1.xz
%_docdir/%name-%version/*
%_docdir/%name-%version/bash_completion/*
%_docdir/%name-%version/xmlrpc/*

#_datadir/locale/*/LC_MESSAGES/aria2.mo


%changelog
