Name: ardour
Version: 8.12
Release: alt1

Summary: Professional multi-track audio recording application
License: GPLv2+
Group:   Sound
Url:     http://ardour.org/

Source:  %name-%version-%release.tar

BuildRequires: gcc-c++ itstool python3-base boost-devel libqm-dsp-devel readline-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aubio)
BuildRequires: pkgconfig(cppunit)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(fftw3f)
BuildRequires: pkgconfig(flac)
BuildRequires: pkgconfig(fluidsynth)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(glibmm-2.4)
BuildRequires: pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(gtkmm-2.4)
BuildRequires: pkgconfig(hidapi-hidraw)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(libarchive)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(liblo)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(lilv-0)
BuildRequires: pkgconfig(lrdf)
BuildRequires: pkgconfig(ltc)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(pangomm-1.4)
BuildRequires: pkgconfig(rubberband)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(serd-0)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(sord-0)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: pkgconfig(sratom-0)
BuildRequires: pkgconfig(suil-0)
BuildRequires: pkgconfig(taglib)
BuildRequires: pkgconfig(vamp-sdk)

%description
Ardour is a digital audio workstation. You can use it to record, edit
and mix multi-track audio. You can produce your own CDs, mix video sound
tracks, or just experiment with new ideas about music and sound.

Ardour capabilities include: multi channel recording, non-destructive
editing with unlimited undo/redo, full automation support, a powerful
mixer, unlimited tracks/busses/plugins, time-code synchronization, and
hardware control from surfaces like the Mackie Control Universal.

See the online user manual at https://manual.ardour.org/toc/

%prep
%setup
# Generate revision number
echo '#include "ardour/revision.h"' > libs/ardour/revision.cc
echo 'namespace ARDOUR { const char* revision = "%version"; const char* date = "'$(date --rfc-3339=date)'"; }' >> libs/ardour/revision.cc

egrep -rl '^#!/usr/bin/env python'|xargs sed -ri '/env python$/ s,$,3,'

%ifarch %e2k
# wscript set CXXFLAGS_OSX without checking sys.platform
# GCC silently ignores -Fxxx options, but LCC responds with an error
sed -i "/conf.env.append_value('CXXFLAGS_OSX', '-F/s|conf.env|pass # conf.env|" wscript
%endif

%build
LC_ALL=C.utf8 ./waf configure \
	--prefix=%_prefix \
	--bindir=%_bindir \
	--configdir=%_sysconfdir \
	--datadir=%_datadir \
	--includedir=%_includedir \
	--libdir=%_libdir \
	--mandir=%_mandir \
	--optimize \
	--arch="%optflags" \
%ifarch armh
	--dist-target=armhf \
%endif
%ifarch aarch64
	--dist-target=aarch64 \
%endif
%ifarch i586
	--dist-target=i686 \
%endif
	--no-phone-home \
	--freedesktop \
	--use-external-libs \
	--no-ytk \
%ifarch %e2k
	--cxx11 \
	--keepflags \
%endif
	#

./waf build i18n -j%([ %__nprocs -gt 32 ] && echo 32 || echo %__nprocs)

%install
./waf --destdir=%buildroot install
install -pm0644 -D ardour.1 %buildroot%_man1dir/ardour.1
install -pm0644 -D gtk2_ardour/resources/Ardour-icon_16px.png %buildroot%_miconsdir/ardour8.png
install -pm0644 -D gtk2_ardour/resources/Ardour-icon_32px.png %buildroot%_niconsdir/ardour8.png
install -pm0644 -D gtk2_ardour/resources/Ardour-icon_48px.png %buildroot%_liconsdir/ardour8.png
install -pm0644 -D tools/udev/surfaces.rules %buildroot%_udevrulesdir/60-ardour-surfaces.rules
install -pm0644    tools/udev/99-cpu-dma-latency.rules %buildroot%_udevrulesdir/

find %buildroot%_bindir -type l |while read l; do
	ln -srvf %buildroot/$(readlink $l) $l
done
%find_lang --output ardour.lang --append ardour8 gtk2_ardour8 gtkmm2ext3

%files -f ardour.lang
%dir %_sysconfdir/ardour8
%config(noreplace) %_sysconfdir/ardour8/*
%_udevrulesdir/*.rules
%_bindir/ardour8*
%_libdir/lib*.so.*
%_libdir/ardour8
%_datadir/ardour8
%_datadir/appdata/ardour8.appdata.xml
%_datadir/mime/packages/ardour.xml
%_desktopdir/ardour8.desktop
%_iconsdir/*/*/*/*.png
%_man1dir/ardour.1*

%changelog
