Name: aqemu
Version: 0.9.2
Release: alt2.1
Epoch: 2

Summary: QEMU GUI written in Qt5
License: GPL-2.0 and Zlib and MIT
Group: Emulators

Url: https://github.com/tobimensch/aqemu
Packager: Boris Savelev <boris@altlinux.org>
Source: %name-%version.tar
# Source-url: https://github.com/tobimensch/aqemu/archive/%version/aqemu-%version.tar.gz
# debian patches
Patch1: 01_qemu_parallel_typo.diff
Patch2: 0002-Remove-VLAN-stuff-QEMU-doesn-t-support-it-anymore.patch
Patch5: 0005-fix-spelling-of-some-words.patch
Patch7: 0007-Fix-crash-because-of-duplicated-widget-name.patch

Requires: qemu qemu-kvm

BuildRequires(pre): cmake rpm-build-ninja
BuildRequires: gcc-c++ libvncserver-devel ImageMagick
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools

ExcludeArch: e2k e2kv4 e2kv5

%description
AQEMU is a QEMU GUI written in Qt5.
It has user-friendly interface and allows to set up the majority of QEMU options.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch5 -p1
%patch7 -p1
# gcc10
sed -i 's|#include <vector>|#include <vector>\n#include <stdexcept>|' src/docopt/docopt_value.h

%build
PATH=%_datadir/qt5/bin:$PATH; export PATH
%cmake_insource \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
#
cmake --build "%_cmake__builddir" -j1

%install
%cmake_install
mkdir -p %buildroot%_desktopdir
install -d %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
convert -size 16x16 ./resources/icons/aqemu.png %buildroot%_miconsdir/%name.png
convert -size 32x32 ./resources/icons/aqemu.png %buildroot%_niconsdir/%name.png
convert -size 48x48 ./resources/icons/aqemu.png %buildroot%_liconsdir/%name.png
rm -rf %buildroot%_datadir/doc/%name

%files
%doc README* AUTHORS* CHANGELOG* TODO*
%_bindir/%name
%dir %_datadir/%name
%_datadir/%name/*
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_miconsdir/%name.png
%_niconsdir/%name.png
%_man1dir/%{name}*
%_pixmapsdir/*.png

%changelog
