%def_disable static

%define aprver 1
%define apudir %name-%version

Name: aprutil%aprver
Version: 1.6.3
Release: alt3

Summary: Apache Portable Runtime Utility shared library
Group: System/Libraries
License: Apache-2.0
Url: https://apr.apache.org/

# Source-url: http://archive.apache.org/dist/apr/apr-util-%version.tar.gz
Source: apr-util-%version.tar

Patch1: aprutil1-1.6.1-alt-mysql8-transition.patch
Patch2: apr-util-1.6.3-lmdb-support.patch

BuildRequires(pre): rpm-macros-branch
BuildPreReq: rpm-build-licenses
%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires: libapr1-devel libexpat-devel zlib-devel libuuid-devel
BuildRequires: libssl-devel
BuildRequires: liblmdb-devel

%package -n lib%name
Summary: Apache Portable Runtime Utility shared library
Group: System/Libraries
Requires: libapr1 > 1.3.0
Conflicts: libaprutil

%package -n lib%name-devel
Summary: Apache Portable Runtime Utility development files
Group: Development/C
Requires: lib%name = %EVR, libapr%aprver-devel > 1.3.0
Requires: libldap-devel

%if_enabled static
%package -n lib%name-devel-static
Summary: Apache Portable Runtime Utility static library
Group: Development/C
Requires: lib%name-devel = %EVR , libapr%aprver-devel-static > 1.3.0
%endif

%description
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.

%description -n lib%name
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU shared library.

%description -n lib%name-devel
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU development files.

%if_enabled static
%description -n lib%name-devel-static
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU static library.
%endif

%package -n lib%name-pgsql
Group: System/Libraries
Summary: APR utility library PostgreSQL DBD driver
BuildRequires: libpq-devel
Requires: lib%name = %EVR

%description -n lib%name-pgsql
This package provides the PostgreSQL driver for the apr-util
DBD (database abstraction) interface.

%package -n lib%name-mysql
Group: System/Libraries
Summary: APR utility library MySQL DBD driver
BuildRequires: libMySQL-devel
Requires: lib%name = %EVR

%description -n lib%name-mysql
This package provides the MySQL driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-sqlite3
Group: System/Libraries
Summary: APR utility library SQLite DBD driver
BuildRequires: libsqlite3-devel >= 3.0.0
Requires: lib%name = %EVR

%description -n lib%name-sqlite3
This package provides the SQLite driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-ldap
Group: System/Libraries
Summary: APR utility library LDAP DBD driver
BuildRequires: libldap-devel
Requires: lib%name = %EVR

%description -n lib%name-ldap
This package provides the LDAP driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-odbc
Group: System/Libraries
Summary: APR utility library ODBC DBD driver
BuildRequires: libunixODBC-devel
Requires: lib%name = %EVR

%description -n lib%name-odbc
This package provides the ODBC driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-openssl
Group: System/Libraries
Summary: APR utility library OpenSSL crypto support
Requires: lib%name = %EVR

%description -n lib%name-openssl
This package provides the OpenSSL crypto support for the apr-util.

%prep
%setup -n apr-util-%version
%patch1 -p2
%patch2 -p1

%build
autoheader && autoconf
%configure \
	--with-apr=%prefix \
	--with-installbuilddir=%_datadir/apr-%aprver/build \
	--includedir=%_includedir/apu-%aprver \
	--with-dbm=lmdb --with-lmdb \
	--with-sqlite3 \
	--with-crypto \
	--with-openssl \
	--with-mysql --with-pgsql \
	--with-ldap \
	%{subst_enable static}

%make_build

%install
%makeinstall_std
find %buildroot%_bindir -type f -print0 |
	xargs -r0 grep -FZl "%_builddir/%apudir" -- |
	xargs -r0 sed -i "s,%_builddir/%apudir,%_datadir/apr-%aprver," --
find %buildroot%_datadir -type f -print0 |
	xargs -r0 grep -FZl "%_builddir/%apudir" -- |
	xargs -r0 sed -i "s,%_builddir/%apudir\(/build\)\?,%_datadir/apr-%aprver/build," --

rm -rf %buildroot%_libdir/apr-util-%aprver/*.la

%check
%make check

%files -n lib%name
%_libdir/lib*.so.*
%dir %_libdir/apr-util-%aprver

%files -n lib%name-devel
%_bindir/*-config
%_libdir/lib*.so
%_libdir/*.exp
%_pkgconfigdir/apr-util-%aprver.pc
%_includedir/*
%_libdir/apr-util-%aprver/apr_dbm_lmdb*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%files -n lib%name-pgsql
%_libdir/apr-util-%aprver/apr_dbd_pgsql*.so

%files -n lib%name-mysql
%_libdir/apr-util-%aprver/apr_dbd_mysql*.so

%if_with sqlite2
%files -n lib%name-sqlite2
%_libdir/apr-util-%aprver/apr_dbd_sqlite2*.so
%endif

%files -n lib%name-sqlite3
%_libdir/apr-util-%aprver/apr_dbd_sqlite3*.so

%files -n lib%name-ldap
%_libdir/apr-util-%aprver/apr_ldap*.so

%files -n lib%name-odbc
%_libdir/apr-util-%aprver/apr_dbd_odbc*.so

%files -n lib%name-openssl
%_libdir/apr-util-%aprver/apr_crypto_openssl*.so

%changelog
