Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: /usr/bin/doxygen
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global debug_package %{nil}
# since we have only a static library

Summary:       ANother Tool for Language Recognition
Name:          antlr
Version:       2.7.7
Release:       alt12_67jpp11
License:       ANTLR-PD
URL:           http://www.antlr2.org/
# ./generate-tarball.sh
Source0:       antlr-%{version}.tar.gz
Source1:       %{name}-build.xml
Source2:       %{name}-script
Source3:       http://repo2.maven.org/maven2/antlr/antlr/%{version}/%{name}-%{version}.pom
# Repack the tarball without prebuilt binaries of unknown origin
Source4:       generate-tarball.sh
Patch1:        %{name}-%{version}-newgcc.patch

BuildRequires: gcc-c++
BuildRequires: ant
BuildRequires: javapackages-local
Source44: import.info

%description
ANTLR, ANother Tool for Language Recognition, (formerly PCCTS) is a
language tool that provides a framework for constructing recognizers,
compilers, and translators from grammatical descriptions containing
C++ or Java actions [You can use PCCTS 1.xx to generate C-based
parsers].

%package     tool
Group: Development/Java
Summary:       ANother Tool for Language Recognition
Provides:      %{name} = %{version}-%{release}
# Explicit requires for javapackages-tools since antlr-script
# uses /usr/share/java-utils/java-functions
Requires:      javapackages-tools
BuildArch:     noarch

%description tool
ANTLR, ANother Tool for Language Recognition, (formerly PCCTS) is a
language tool that provides a framework for constructing recognizers,
compilers, and translators from grammatical descriptions containing
C++ or Java actions [You can use PCCTS 1.xx to generate C-based
parsers].

%package     manual
Group: Development/Java
Summary:       Manual for %{name}
BuildArch:     noarch

%description manual
Documentation for %{name}.

%package     javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch:     noarch

%description javadoc
Javadoc for %{name}.

%package     C++
Group: Development/Java
Summary:       C++ bindings for antlr2 generated parsers
Provides:      antlr-static = %{version}-%{release}

%description C++
This package provides a static C++ library for parsers generated by ANTLR2.

%prep
%setup -q
# remove all binary libs
find . -name "*.jar" -exec rm -f {} \;
cp -p %{SOURCE1} build.xml
%patch1
# CRLF->LF
sed -i 's/\r//' LICENSE.txt

# set jar location
%mvn_file %{name}:%{name} %{name}

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Dj2se.apidoc=%{_javadocdir}/java
# make expects to find it here
cp work/lib/antlr.jar .
export CLASSPATH=.
%configure --without-examples
make CXXFLAGS="${CXXFLAGS} -fPIC" DEBUG=1 verbose=1
# no longer needed
rm antlr.jar

# fix doc permissions and remove Makefiles
rm doc/{Makefile,Makefile.in}
chmod 0644 doc/*

%install
# jars, POM and depmap
%mvn_artifact %{SOURCE3} work/lib/%{name}.jar
%mvn_alias %{name}:%{name} %{name}:%{name}all
%mvn_install -J work/api

mkdir -p $RPM_BUILD_ROOT{%{_includedir}/%{name},%{_libdir},%{_bindir}}
# script
install -p -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{_bindir}/antlr

# C++ lib and headers, antlr-config
install -p -m 644 lib/cpp/antlr/*.hpp $RPM_BUILD_ROOT%{_includedir}/%{name}
install -p -m 644 lib/cpp/src/libantlr.a $RPM_BUILD_ROOT%{_libdir}
install -p -m 755 scripts/antlr-config $RPM_BUILD_ROOT%{_bindir}
chmod 755 $RPM_BUILD_ROOT%{_bindir}/*

%files tool -f .mfiles
%doc --no-dereference LICENSE.txt
%{_bindir}/antlr

# this is actually a development package for the C++ target
# as we ship only a static library, it doesn't make sense
# to have a separate -devel package for the headers
%files C++
%doc --no-dereference LICENSE.txt
%{_includedir}/%{name}
%{_libdir}/libantlr.a
%{_bindir}/antlr-config

%files manual
%doc --no-dereference LICENSE.txt
%doc doc/*

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
