# requires pandoc
%def_enable docs
%global llvm_version 20.1

Name: android-tools
Version: 34.0.5
Release: alt4

Summary: Android Debug CLI tools
License: APL
Group: Development/Tools

Url: https://developer.android.com/studio/releases/platform-tools
# Debian's package: https://salsa.debian.org/android-tools-team/android-platform-tools.git
#
# fetching upstream sources (~/.gitconfig will be temporary backed-up as ~/.gitconfig.get-orig-source):
# PLATFORM_TOOLS_VERSION="34.0.4" DEB_SOURCE="deb" debian/get-orig-source
#
# repo tool is needed, see https://gerrit.googlesource.com/git-repo/+/refs/heads/main/README.md

Source: %name-%version-%release.tar

# Debian core patches
Patch0: Revert-Remove-mips-support.patch
Patch1: Revert-Remove-mips-build.patch
Patch2: Revert-Remove-mips-support-fr.patch
Patch3: Revert-Remove-a-file-we-haven-t-built-since-2013.patch
Patch4: support-mips.patch
Patch5: Revert-3-Add-rust-demangling.patch
Patch6: Revert-Replacing-hardcoded-types-with-decltype-for-e.patch
Patch7: Revert-Enforcing-static-invariants-to-prevent-failur.patch
Patch8: Revert-Drop-all-path-rel.patch
Patch9: Revert-Lose-convertToResPath-to-aapt.patch
Patch10: stdatomic.patch
Patch11: workaround__builtin_available.patch
Patch12: Nullable.patch
Patch13: unwindstack-porting.patch
Patch14: move-log-file-to-proper-dir.patch
Patch15: Added-missing-headers.patch
Patch16: libusb-header-path.patch
Patch17: throw-exception-on-unknown-os.patch
Patch18: hard-code-build-number.patch
Patch19: stub-out-fastdeploy.patch
Patch20: Implement-const_iterator-operator.patch
Patch21: Drop-gki-dependency-from-mkbootimg.patch
Patch22: gcc-14.patch
Patch23: add-missing-headers.patch
Patch24: typos.patch

# Debian, from boringssl package
Patch100: Add-new-Arch-ia64-riscv64-sh4-x32.patch
Patch101: sources-mk.patch
Patch102: Disable-failing-test.patch
Patch103: Revert-Remove-support-for-ppc64le.patch
Patch104: loong64.patch

# ALT fixes
Patch200: alt-libziparchive-compile-fix.patch
Patch201: alt-absl-workaround.patch

# LoongArch
Patch3500: boringssl-loongarch64.patch
Patch3501: libunwindstack-loongarch64.patch

%ifarch loongarch64
# XXX: as of LLVM 17 lld supports only a subset of LoongArch relocations.
# Thus lld is unable to use libraries built with GNU ld (including libc).
%def_without lld
%else
%def_with lld
%endif

Requires: udev-android

BuildRequires: clang%{llvm_version} clang%{llvm_version}-support
%if_with lld
BuildRequires: lld%{llvm_version}
%endif
BuildRequires: llvm%{llvm_version}-devel
BuildRequires: libstdc++-devel

BuildRequires: liblzma-devel
BuildRequires: zlib-devel libselinux-devel
BuildRequires: libusb-devel libgtest-devel libsafe-iop-devel
BuildRequires: libunwind-devel
BuildRequires: protobuf-compiler libprotobuf-devel
BuildRequires: squashfuse-devel
BuildRequires: libbrotli-devel
BuildRequires: liblz4-devel
BuildRequires: libzstd-devel
BuildRequires: libpng-devel

%if_enabled docs
BuildRequires: pandoc
%endif

BuildRequires: rpm-build-python3

%description
This package contains following utilities:

Android Debug Bridge (adb) -- it is a versatile command line tool, which lets
you communicate with an emulator instance or connected Android-powered device.

fastboot -- a command line tool for flashing an Android device, boot an Android
device to fastboot mode, etc.

mkbootimg -- creates Android boot images that includes kernel image and ramdisk,
in a special format which can be used with fastboot.

Command line tools to create sparse images for usage with Android devices.
Includes sim2img, img2simg, simg2simg and append2simg tools.

etc1tool -- a command line utility that lets you encode PNG images to the ETC1
compression standard and decode ETC1 compressed images back to PNG. It is part
of the Android SDK for working with media files for game apps. The standard for
the ETC1 texture format is here:
http://www.khronos.org/registry/gles/extensions/OES/OES_compressed_ETC1_RGB8_texture.txt

hprof-conv -- converts the HPROF file that is generated by the Android SDK tools
to a standard format so you can view the file in a profiling tool of your
choice.

%prep
%setup
# applying Debian patches
#%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
#%patch6 -p1
#%patch7 -p1
#%patch8 -p1
#%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

pushd external/boringssl
%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
# replaced by boringssl-loongarch64.patch
#%patch104 -p1
popd
%patch200 -p1
%patch201 -p1
%patch3500 -p1
%patch3501 -p1

rm -rf development/[a-s]* development/v* development/testrunner

for proto in packages/modules/adb/fastdeploy/proto packages/modules/adb/proto; do
		(cd $proto && find . -name '*.proto' -printf 'Regenerate %%p\n' -exec protoc --cpp_out=. {} \;)
done

%build

%if_with lld
# XXX: only LLD supports thin LTO
%define optflags_lto -flto=thin
%else
%define optflags_lto %nil
%endif

%add_optflags %optflags_shared

%define makefilesdir %_builddir/%name-%version/debian/makefiles
%define outbindir %_builddir/%name-%version/out_bin
%define outlibdir %_builddir/%name-%version/out_lib
%define outmandir %_builddir/%name-%version/out_man

%define aprefix %_libdir/android

case %_arch in
    "aarch64")
        DEB_HOST_ARCH="arm64"
        ;;
    "armh")
        DEB_HOST_ARCH="armhf"
        ;;
    "i586")
        DEB_HOST_ARCH="i386"
        ;;
    "x86_64")
        DEB_HOST_ARCH="amd64"
        ;;
    "ppc64le")
        DEB_HOST_ARCH="ppc64el"
        ;;
    "mipsel")
        DEB_HOST_ARCH="mipsel"
        ;;
    "loongarch64")
        DEB_HOST_ARCH="loong64"
        ;;
    "riscv64")
        DEB_HOST_ARCH="riscv64"
        ;;
    *)
        false
        ;;
esac

CC="clang"
CXX="clang++"

CFLAGS+=" %optflags -std=gnu17 -gdwarf-4"

CPPFLAGS+=" %optflags -DNDEBUG -UDEBUG -fmessage-length=0 -fno-exceptions"
CPPFLAGS+=" -fno-strict-aliasing -no-canonical-prefixes"
CPPFLAGS+=" -Wno-c99-designator -Wno-gnu-designator -Wno-gnu-folding-constant"
CPPFLAGS+=" $(getconf LFS_CFLAGS)"

CXXFLAGS+=" -std=gnu++2a -gdwarf-4"
%if_with lld
LDFLAGS+=" -fuse-ld=lld"
%endif

LDFLAGS+=" -Wl,--build-id=sha1 -Wl,-rpath,%aprefix/lib -L%outlibdir"

export LLVM_LIBDIR=`llvm-config --libdir`
export CLANG_MAJVER=`echo %llvm_version | cut -d. -f1`
export CLANG_INCDIR="${LLVM_LIBDIR}/clang/${CLANG_MAJVER}/include/"

CXXFLAGS+=" -I${CLANG_INCDIR}" # for stdbool.h and alike
CPPFLAGS+=" -I${CLANG_INCDIR}" # for stddef.h and alike

DEB_VERSION=%version
export CC CXX CFLAGS CPPFLAGS CXXFLAGS LDFLAGS DEB_VERSION DEB_HOST_ARCH

mkdir -p %outbindir
mkdir -p %outlibdir
mkdir -p %outmandir

# building boringssl
pushd external/boringssl
OUT_DIR=%outlibdir MAKEFILES_DIR=%makefilesdir make -j$(nproc) -f %makefilesdir/libcrypto.mk
OUT_DIR=%outlibdir MAKEFILES_DIR=%makefilesdir make -j$(nproc) -f %makefilesdir/libssl.mk
popd

extras_components_libs=" \
        libcpu_features \
        liblzma \
		    libext4_utils \
        libETC1"

core_components_libs=" \
		    liblog \
		    libbase \
		    libcutils \
 		    libbacktrace \
		    libsparse \
		    libutils \
		    libziparchive \
		    libcrypto_utils \
        libnativehelper"

core_simg_tools=" \
		    simg2img \
		    simg2simg \
		    img2simg \
		    append2simg"

core_tools="adb fastboot"

misc_tools="etc1tool hprof-conv"

# building extra libraries
for i in $extras_components_libs; do
    OUT_DIR=%outlibdir make -j$(nproc) -f %makefilesdir/$i.mk
done

# building core libraries
for i in $core_components_libs; do
    OUT_DIR=%outlibdir make -j$(nproc) -f %makefilesdir/$i.mk
done

# libadb requires a bit more variables
OUT_DIR=%outlibdir \
    PLATFORM_TOOLS_VERSION=%version \
    DEB_VERSION=%version-%release \
    make -j$(nproc) -f %makefilesdir/libadb.mk

# building core tools
for i in $core_tools; do
    OUT_DIR=%outbindir \
        OUT_LIBS_DIR=%outlibdir \
        DEB_VERSION=%version-%release \
        PLATFORM_TOOLS_VERSION=%version \
        make -j$(nproc) -f %makefilesdir/$i.mk
done

# simg tools
for i in $core_simg_tools; do
    OUT_DIR=%outbindir \
        make -j$(nproc) -f %makefilesdir/$i.mk
done

# misc tools
for i in $misc_tools; do
    OUT_DIR=%outbindir \
        OUT_LIBS_DIR=%outlibdir \
        make -j$(nproc) -f %makefilesdir/$i.mk
done

# building man pages
%if_enabled docs
for i in adb fastboot etc1tool; do
    pandoc -s -o %outmandir/$i.1 debian/$i.1.md
done
%endif

# do not forget about mkbootimg
cp system/tools/mkbootimg/mkbootimg.py %outbindir/mkbootimg
cp system/tools/mkbootimg/unpack_bootimg.py %outbindir/unpack_bootimg
cp system/tools/mkbootimg/repack_bootimg.py %outbindir/repack_bootimg

%install

mkdir -p %buildroot%_bindir %buildroot%aprefix/bin %buildroot%aprefix/lib %buildroot%_man1dir

for i in adb fastboot mkbootimg unpack_bootimg repack_bootimg; do
    install -pm0755 %outbindir/$i %buildroot%_bindir/$i
done
for i in append2simg img2simg simg2img simg2simg etc1tool hprof-conv; do
    install -pm0755 %outbindir/$i %buildroot%aprefix/bin
done

cp -a %outlibdir/*.so %buildroot%aprefix/lib
cp -a %outlibdir/*.so.* %buildroot%aprefix/lib

for i in adb fastboot etc1tool; do
    install -pm0644 %outmandir/$i.1 %buildroot%_man1dir
done

mkdir -p %buildroot%_sysconfdir/bash_completion.d
for i in adb fastboot; do
    install -pm0644 debian/bash_completion.d/$i %buildroot%_sysconfdir/bash_completion.d
done

%add_findreq_skiplist	%_bindir/mkbootimg
%add_findreq_skiplist	%_bindir/unpack_bootimg
%add_findreq_skiplist	%_bindir/repack_bootimg

%files
%_bindir/*
%_man1dir/*
%_sysconfdir/bash_completion.d/*
%aprefix

%changelog
