%define sname mediawriter
%define oname ALTMediaWriter
%define appId ru.basealt.altmediawriter

Name:           altmediawriter
Version:        1.0.11
Release:        alt1
Summary:        ALT Media Writer
Group:          System/Configuration/Other
Packager:       Maria Alexeeva <alxvmr@altlinux.org>

License:        GPLv2+
URL:            https://altlinux.space/ALTLinux/ALTMediaWriter
Source:         %oname-%version.tar

BuildRequires:  liblzma-devel
BuildRequires:  libyaml-cpp-devel
BuildRequires:  qt5-declarative-devel
BuildRequires:  qt5-x11extras-devel
BuildRequires:  libappstream-glib

Requires:       qt5-quickcontrols
Requires:       qt5-quickcontrols2
Requires:       polkit
Requires:       udisks2

%description
A tool to write images of ALT media to portable drives
like flash drives or memory cards.

%prep
%setup -n %oname-%version

%build
%qmake_qt5 PREFIX=%_prefix LIBEXECDIR=%_libexecdir/%name MEDIAWRITER_NAME=%name MEDIAWRITER_VERSION=%version-%release
%make_build

%install
make install INSTALL_ROOT=%buildroot
if [ "%name" != "%sname" ]; then
    for i in %buildroot%_datadir/icons/hicolor/*/apps/%{sname}*.svg; do
        new_name=$(basename "$i" | sed "s/^%sname/%name/")
        mv "$i" "$(dirname $i)/$new_name"
    done
    mv %buildroot%_datadir/applications/%sname.desktop %buildroot%_datadir/applications/%appId.desktop
    mv %buildroot%_datadir/appdata/%sname.appdata.xml %buildroot%_datadir/appdata/%name.appdata.xml
    sed -i 's/=%sname$/=%name/g' %buildroot%_datadir/applications/%appId.desktop
    sed -i 's/%sname\.desktop/%appId.desktop/' %buildroot%_datadir/appdata/%name.appdata.xml
fi

%check
appstream-util validate-relax --nonet %buildroot/%_datadir/appdata/%name.appdata.xml

%files
%_bindir/%name
%_libexecdir/%name/
%_datadir/appdata/%name.appdata.xml
%_datadir/applications/%appId.desktop
%_iconsdir/hicolor/*/*/*.svg


%changelog
