%define _unpackaged_files_terminate_build 1
%define mod_name alterator_entry

Name: alterator-entry
Version: 0.4.5
Release: alt1

Summary: Common files for Alterator Entry specification
License: GPLv3+
Group: Other
URL: https://altlinux.space/alterator/alterator-entry

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name

BuildArch: noarch

BuildRequires(pre): rpm-macros-alterator

%description
Common files for Alterator Entry specification:
- specification documents
- TOML schemas for Alterator Entry types
- alterator-entry script to validate Alterator Entry files and extract data
- editions2packages script to extract packages from editions

%package -n python3-module-alterator-entry
Summary: Python3 module to validate and extract fields from Alterator Entry
Group: Development/Python3

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: python3-module-tomlkit
BuildRequires: python3-module-jsonschema

%description -n python3-module-alterator-entry 
%summary.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
install -D -m 755 scripts/alterator-entry %buildroot%_bindir/alterator-entry
install -D -m 755 scripts/editions2packages %buildroot%_bindir/editions2packages

mkdir -p %buildroot%_alterator_datadir
cp -r ./schemas %buildroot%_alterator_datadir/schemas 

%check
export ALTERATOR_SCHEMAS_DIR=./schemas
export PYTHONPATH=./alterator_entry:$PYTHONPATH
find examples -type f | xargs ./scripts/alterator-entry validate

%files
%doc COPYING
%doc %_alterator_datadir/schemas/
%_bindir/alterator-entry
%_bindir/editions2packages

%files -n python3-module-alterator-entry
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %mod_name}

%changelog
