%define qbIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define qbIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define qbIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define qbIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%define alternatives_ver %{get_version alternatives}
%define alterator_cfg %_sysconfdir/alterator

%define bin_name alterator-browser-qt6
%define raw_name alterator-browser-qt

Name: %bin_name
Version: 3.7.1
Release: alt1

Source:%name-%version.tar

Summary: Qt GUI interface driver for Alterator
License: GPL
Group: System/Configuration/Other

Requires(post,preun): alternatives >= 0.2
Requires: qt6-translations
Requires: qt6-virtualkeyboard
Requires: qt6-svg
Requires: /usr/bin/xdg-open
Requires: alterator-browser-gui-common
Requires: alterator-common >= 2.9-alt0.14
Requires: alterator-icons
Provides: alterator-browser
Obsoletes: alterator-browser
Provides: alterator-browser-x11
Provides: alterator-browser-qt-light = 2.8-alt1
Obsoletes: alterator-browser-qt-light < 2.8-alt1
Provides: alterator-browser-qt = %version-%release
Obsoletes: alterator-browser-qt < %version-%release
Provides: alterator-browser-qt4 = %version-%release
Obsoletes: alterator-browser-qt4 < %version-%release
Provides: alterator-browser-qt5 = %version-%release
Obsoletes: alterator-browser-qt5 < %version-%release
Obsoletes: alterator-look-qt

BuildRequires: libalternatives-devel
BuildRequires: libudev-devel
BuildRequires: qt6-base-devel qt6-tools

%description
Qt GUI interface driver for Alterator.

%prep
%setup -q
%qmake_qt6

%build
%make_build
lrelease-qt6 %raw_name.pro

%install
%install_qt6
mv  %buildroot/%_bindir/%raw_name %buildroot/%_bindir/%bin_name

# translations
mkdir -p %buildroot/%_qt6_translationdir
install -m 0644 translations/*.qm %buildroot/%_qt6_translationdir/

mkdir -p %buildroot/%_altdir
cat >%buildroot/%_altdir/%name <<__EOF__
%_bindir/alterator-browser-x11	%_bindir/%bin_name 11
%_bindir/%raw_name	%_bindir/%bin_name 11
%_bindir/qtbrowser	%_bindir/%bin_name 11
__EOF__

# install desktop-file
mkdir -p %buildroot/%_desktopdir/
install -m 0644 /dev/null %buildroot/%_desktopdir/%{name}.desktop
cat >%buildroot/%_desktopdir/%{name}.desktop <<__EOF__
[Desktop Entry]
Name=%name
Type=Application
Icon=alterator
Categories=Qt;KDE;System;
Exec=%name
NoDisplay=true
__EOF__

#mkdir -p %buildroot/%alterator_cfg
#ln -s /dev/null %buildroot/%alterator_cfg/design-browser-qt
#mkdir -p %buildroot/%_datadir/%name/design
#ln -s %alterator_cfg/design-browser-qt %buildroot/%_datadir/%name/design/current

%find_lang --with-qt --all-name %name

%files -n %bin_name -f %name.lang
%config %_altdir/%bin_name
#%ghost %config %alterator_cfg/design-browser-qt
%_bindir/%bin_name
#%_datadir/%name/
%_desktopdir/%{name}.desktop

%changelog
