Name: alt-gpgkeys
Version: 0.8.122
Release: alt1

Summary: ALT GnuPG keys
License: GPL-2.0-or-later
Group: System/Configuration/Packaging
Packager: ALT Security Team <security@altlinux.com>
BuildArch: noarch

Source0: options
Source1: keys.tar
Source2: alt-gpgkey-check
Source3: alt-gpgkey-strip
Source4: alt-rpmkeys-checksig

Conflicts: gnupg < 0:1.2.0
BuildPreReq: gnupg, libshell

%description
This package contains ALT Linux Team GnuPG keyring.

%package utils
Summary: Utilities to manipulate %name
License: GPL-2.0-or-later
Group: System/Configuration/Packaging
Requires: %name = %version-%release

%description utils
This package contains utilities to manipulate %name.

%package -n alt-rpmkeys
Summary: ALT GnuPG keys imported into RPM database
License: GPL-2.0-or-later
Group: System/Configuration/Packaging
Requires: %name = %version-%release

%description -n alt-rpmkeys
This package contains ALT Linux Team GnuPG keys imported into RPM database.

%package -n alt-rpmkeys-utils
Summary: Utilities to manipulate alt-rpmkeys
License: GPL-2.0-or-later
Group: System/Configuration/Packaging
Requires: alt-rpmkeys = %version-%release

%description -n alt-rpmkeys-utils
This package contains utilities to manipulate alt-rpmkeys.

%prep
%setup -qcT -n %name -a 1
install -pm755 %_sourcedir/{alt-gpgkey-check,alt-gpgkey-strip,alt-rpmkeys-checksig} .
mkdir -m700 home
mkdir -m700 rpmdb

%build
gpg --homedir home </dev/null ||:
for f in keys/*; do
	./alt-gpgkey-check "$f"
	gpg --homedir home --import "$f"
done
install -pm600 %_sourcedir/options home/gpg.conf
gpg --homedir home --list-keys
gpg --homedir home --export --armor > all.gpg
rpmkeys --dbpath "$PWD/rpmdb" --import all.gpg

%install
%define gpgkeydir %_prefix/lib/%name
cd home
mkdir -p %buildroot%gpgkeydir
install -pm644 gpg.conf pubring.gpg secring.gpg \
	%buildroot%gpgkeydir/
cd ..

%define rpmkeydir %_prefix/lib/alt-rpmkeys
cd rpmdb
mkdir -p %buildroot%rpmkeydir
cp -p Packages Name %buildroot%rpmkeydir/
chmod -R a-w %buildroot%rpmkeydir/
cd ..

mkdir -p %buildroot%_bindir
install -pm755 alt-gpgkey-check alt-gpgkey-strip alt-rpmkeys-checksig \
	%buildroot%_bindir/

%define _unpackaged_files_terminate_build 1

%files
%gpgkeydir/

%files utils
%_bindir/alt-gpgkey*

%files -n alt-rpmkeys
%rpmkeydir/

%files -n alt-rpmkeys-utils
%_bindir/alt-rpmkey*

%changelog
