Name: alacritty
Version: 0.16.1
Release: alt1

Summary: A fast, cross-platform, OpenGL terminal emulator
License: Apache-2.0
Group: Terminals
Url: https://github.com/alacritty/alacritty

Source0: %name-%version.tar
Source1: crates.tar

BuildRequires: scdoc
BuildRequires: rust-cargo /proc
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xcb-render)
BuildRequires: pkgconfig(xcb-shape)
BuildRequires: pkgconfig(xcb-xfixes)
BuildRequires: pkgconfig(xkbcommon)

%description
Alacritty is a modern terminal emulator that comes with sensible defaults, but
allows for extensive configuration. By integrating with other applications,
rather than reimplementing their functionality, it manages to provide a flexible
set of features with high performance. The supported platforms currently consist
of BSD, Linux, macOS and Windows.

%prep
%setup -a1
%ifdef bootstrap
cargo vendor
tar cf %SOURCE1 .cargo vendor
%endif

%build
cargo build --release

%install
mkdir -p %buildroot%_man1dir %buildroot%_man5dir
scdoc < extra/man/alacritty.1.scd > %buildroot%_man1dir/alacritty.1
scdoc < extra/man/alacritty-msg.1.scd > %buildroot%_man1dir/alacritty-msg.1
scdoc < extra/man/alacritty.5.scd > %buildroot%_man5dir/alacritty.5
scdoc < extra/man/alacritty-bindings.5.scd > %buildroot%_man5dir/alacritty-bindings.5
install -pm0755 -D target/release/alacritty %buildroot%_bindir/alacritty
install -pm0644 -D extra/linux/Alacritty.desktop %buildroot%_desktopdir/Alacritty.desktop
install -pm0644 -D extra/logo/alacritty-term.svg %buildroot%_iconsdir/hicolor/scalable/apps/Alacritty.svg
install -pm0644 -D extra/completions/_alacritty %buildroot%_datadir/zsh/site-functions/_alacritty
install -pm0644 -D extra/completions/alacritty.bash %buildroot%_datadir/bash-completion/completions/alacritty
install -pm0644 -D /dev/null %buildroot%_sysconfdir/alacritty/alacritty.toml

%files
%doc README* LICENSE* docs/*

%dir %_sysconfdir/alacritty
%ghost %config(noreplace) %_sysconfdir/alacritty/alacritty.toml

%_bindir/alacritty

%_datadir/zsh/site-functions/_alacritty
%_datadir/bash-completion/completions/alacritty

%_desktopdir/Alacritty.desktop
%_iconsdir/hicolor/scalable/apps/Alacritty.svg

%_man1dir/alacritty*.1*
%_man5dir/alacritty*.5*

%changelog
