%def_with emacs

%define prerel %nil
%define _name timidity

# Solution from OpenSuse
%global optflags_lto %nil

Name: TiMidity++
Version: 2.15.0
Release: alt1.3

Summary: Great-sounding CPU-hungry MIDI soundfile player
License: GPLv2
Group: Sound

Url: http://timidity.sourceforge.net
Source0: http://prdownloads.sourceforge.net/timidity/%name-%version%prerel.tar.bz2
Source1: timidity.init
Source2: timidity.sysconfig
Source3: timidity.desktop
Source100: TiMidity++.watch

# ALT patches
Patch0: TiMidity++-2.13.0-alt-config.patch
Patch4: TiMidity++-2.14.0-tcltk-link.patch

# Debian patches
# 0002-improve-error-message.patch
Patch100: TiMidity++-deb-improve-error-message.patch
# 0004-Fix-off-by-one-crash-error-in-panning-reverb.patch
Patch101: TiMidity++-deb-fix-off-by-one-crash-error-in-panning-reverb.patch
# 0006-Don-t-crash-when-started-in-daemon-mode.patch
Patch102: TiMidity++-deb-don-t-crash-when-started-in-daemon-mode.patch
# 0010-Pass-LDFLAGS-to-addon-linking.patch
Patch103: TiMidity++-deb-pass-ldflags-to-addon-linking.patch
# 0011-Fix-spelling-errors-found-by-lintian.patch
Patch104: TiMidity++-deb-fix-spelling-errors-found-by-lintian.patch

# SUSE patches
Patch200: TiMidity++-suse-fix-alsaseq-polling-at-idle-time.patch
Patch201: TiMidity++-suse-timidity-no-date.patch
Patch202: TiMidity++-suse-timidity-readmidi-zero-division-fix.patch
Patch203: TiMidity++-suse-timidity-resample-frac-overflow-fix.patch

%define tcl_ver 8.4.0-alt1
%define tk_ver 8.4.0-alt1

Requires: timidity-instruments
Requires: tcl >= %tcl_ver, tk >= %tk_ver

# just a file conflict
Conflicts: fluid-soundfont-lite-patches

# Automatically added by buildreq on Thu Feb 28 2019
# optimized out: emacs-base emacs-common fontconfig fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libICE-devel libSM-devel libX11-devel libX11-locales libXext-devel libXmu-devel libXt-devel libatk-devel libaudiofile-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libogg-devel libp11-kit libpango-devel libpng-devel libtinfo-devel pkg-config python-base python-modules xorg-proto-devel zlib-devel
BuildRequires: libXaw3d-devel libalsa-devel libao-devel libesd-devel libflac-devel libgtk+2-devel libjack-devel libncurses-devel libopenmotif-devel libslang2-devel libspeex-devel libvorbis-devel
%{?_with_emacs:BuildRequires: emacs-nox}

BuildRequires: tcl-devel >= %tcl_ver, tk-devel >= %tk_ver

Summary(ru_RU.UTF-8): Конвертер/проигрыватель MIDI-файлов
Summary(uk_UA.UTF-8): Конвертер/програвач MIDI-файлів

%description
TiMidity++ is a converter that converts some of MIDI files
(formats : Standard MIDI file (*.MID), Recomposer files (*.RCP, *.R36,
*.G18, *.G36) and Module file (*.mod)) into formatted audio file  (ex
.RIFF  WAVE). TiMidity uses Gravis Ultrasound-compatible patch files or
Soundfonts( *.sfx, *.sf2 ) to generate digital audio data from MIDI
files. The digital audio data generated by TiMidity can be stored in a
file for processing, or played in real time through an audio device. In
real time playing, TiMidity if able to show the lyric contained in KAR
file or WRD file.

%description -l ru_RU.UTF-8
TiMidity++ -- проигрыватель MIDI-файлов, не требующий аппаратной
поддержки MIDI и использующий для синтеза внешнюю wavetable в
виде так называемых патчей (patch files) -- совместимых со
стандартом Gravis Ultrasound .pat-файлов (по одному на
инструмент). Коллекции патчей находятся в пакетах
timidity-instruments и timidity-eaw-patches.

%description -l uk_UA.UTF-8
TiMidity++ -- програвач MIDI-файлів, що не потребує апаратної
підтримки MIDI та використовує для синтезу зовнішню wavetable у
вигляді т.н.  патчів (patch files) -- сумісних із стандартом
Gravis Ultrasound .pat-файлів (по одному на інструмент). Колекції
патчів знаходяться у пакунках timidity-instruments та
timidity-eaw-patches.

%prep
%setup -n %name-%version%prerel
%patch0 -p1
%patch4 -p2
%patch100 -p2
%patch101 -p2
%patch102 -p2
%patch103 -p2
%patch104 -p2
%patch200 -p1
%patch201 -p0
%patch202 -p1
%patch203 -p1
cp -a INSTALL INSTALL.orig

%build
%add_optflags -DUSE_INTERP_RESULT -DSTDC_HEADERS
%define _optlevel 3
export EXTRACFLAGS="-DUSE_NON_CONST %optflags %optflags_fastmath %optflags_notraceback"
%configure \
    --program-prefix="" \
    --enable-interface=xaw,ncurses,gtk,tcltk,%{?_with_emacs:emacs,}slang \
    --enable-audio=default,oss,alsa,esd,vorbis,ao,jack,flac,speex \
    --with-default-output=alsa \
    --enable-server \
    --enable-alsaseq \
    --enable-network \
    --enable-spectrogram \
    --enable-wrd \
    --enable-dynamic \
    --enable-vt100 \
    --enable-spline=cubic

%make_build

%install
%makeinstall

# bonus tracks
install -pDm755 %SOURCE1 %buildroot%_initdir/%_name
install -pDm644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%_name
install -pDm644 %SOURCE3 %buildroot%_desktopdir/%_name.desktop
install -pDm644 interface/pixmaps/%_name.xpm %buildroot%_liconsdir/%_name.xpm

# default config
mkdir -p %buildroot%_sysconfdir
echo "dir %_datadir/%_name" >%buildroot%_sysconfdir/%_name.cfg

# fixups
sed -i 's,%buildroot,,g' %buildroot%_usr/lib/%_name/tkmidity.tcl
%if_with emacs
sed -i  -e 's@/usr/local/bin/%_name@%_bindir/%_name@' \
	-e 's@%buildroot@@' interface/%_name.el
install -pDm644 interface/%_name.el %buildroot%_emacslispdir/%_name.el
%endif

%files
%_bindir/%_name
%_usr/lib/%_name
%_mandir/*/*
%if_with emacs
%_emacslispdir/%_name.el
%endif
%_desktopdir/%_name.desktop
%_liconsdir/*
%_initdir/%_name
%_sysconfdir/sysconfig/%_name
%config(noreplace) %_sysconfdir/%_name.cfg
%doc ChangeLog INSTALL.orig README
%doc doc/C/{README*,FAQ}

%changelog
