%define _unpackaged_files_terminate_build 1
%def_enable opus
%def_enable lz4
%def_enable gstreamer
%def_disable manual
# Tests build fail with lto. What to disable, tests or lto?
%def_enable tests

Name: SPICE
Version: 0.16.0
Release: alt1
Summary: Implements the SPICE protocol
Group: Graphical desktop/Other
License: LGPLv2+
Url: http://www.spice-space.org/

# VCS: https://gitlab.freedesktop.org/spice/spice.git
Source: %name-%version.tar
Source2: spice-common.tar
Source3: spice-common-recorder.tar
#Patch1: fix-alt.patch

BuildRequires: gcc-c++
BuildRequires(pre): meson >= 0.49.0
BuildRequires: libjpeg-devel libpixman-devel >= 0.17.7 zlib-devel
BuildRequires: libssl-devel >= 1.1.0 libsasl2-devel openssl
BuildRequires: libcacard-devel >= 2.5.1
BuildRequires: python3-module-six python3-module-pyparsing
BuildRequires: glib2-devel >= 2.38
BuildRequires: libgdk-pixbuf-devel >= 2.26
BuildRequires: spice-protocol >= 0.14.5
%{?_enable_manual:BuildRequires: asciidoc asciidoc-a2x}
%{?_enable_opus:BuildRequires: libopus-devel >= 0.9.14}
%{?_enable_lz4:BuildRequires: liblz4-devel}
%{?_enable_gstreamer:BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel gst-plugins1.0-gir-devel liborc-devel}

%description
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

%package -n libspice-server
Summary: Implements the server side of the SPICE protocol
Group: System/Libraries

%description -n libspice-server
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

This package contains the run-time libraries for any application that wishes
to be a SPICE server.

%package -n libspice-server-devel
Summary: Header files, libraries and development documentation for spice-server
Group: Development/C
Requires: libspice-server = %version-%release

%description -n libspice-server-devel
This package contains the header files, static libraries and development
documentation for spice-server. If you like to develop programs
using spice-server, you will need to install spice-server-devel.

%prep
%setup
mkdir -p subprojects
tar -xf %SOURCE2 -C subprojects/spice-common
tar -xf %SOURCE3 -C subprojects/spice-common/common/recorder
# version in .tarball-version file
echo "%version" > .tarball-version
#%%patch1 -p1
%ifarch %e2k
# workaround for regression in LCC 1.26 when default gnu++14 is used
sed -i "/global_cxxflags +=/a '-std=gnu++17'," meson.build
# workaround for bug that causes spice_server_kbd_leds() to be hidden
sed -i 's/int spice_server_kbd_leds/__attribute__((visibility("default"))) &/' server/inputs-channel.h
%endif

%build
%meson \
    %{?_disable_tests:-Dtests=false} \
    %{?_disable_gstreamer:-Dgstreamer=no}

%meson_build

%install
%meson_install
rm -f %buildroot%_libdir/libspice-server.a
rm -f %buildroot%_libdir/libspice-server.la

%files -n libspice-server
%doc COPYING README CHANGELOG.md
%_libdir/libspice-server.so.*

%files -n libspice-server-devel
%_includedir/spice-server
%_libdir/libspice-server.so
%_pkgconfigdir/spice-server.pc

%changelog
