%define _unpackaged_files_terminate_build 1

%define audiosover 2
%define coresover 10
%define sover 5
%define progectlicense GPL-2.0

Name:    RHVoice
Version: 1.16.5
Release: alt1

Summary: a free and open source speech synthesizer for Russian and other languages
License: %progectlicense
Group: Sound
Url: https://github.com/RHVoice/RHVoice

Source0: %name-%version.tar

BuildRequires: scons
BuildRequires: gcc-c++        
BuildRequires: libgio-devel
BuildRequires: pkg-config
BuildRequires: libpulseaudio-devel
BuildRequires: libao-devel
BuildRequires: libportaudio2-devel
BuildRequires: libspeechd-devel
BuildRequires: flite-devel
BuildRequires: boost-devel

%description
%summary

%package -n lib%name%sover
Summary: Lib files for %name
Group: System/Libraries
Provides: RHVoice = %EVR
Obsoletes: RHVoice < %EVR
Provides: libRHVoice = %EVR
Obsoletes: libRHVoice < %EVR

%description -n lib%name%sover
%summary

%files -n lib%name%sover
%_libdir/lib%name.so.%sover
%_libdir/lib%name.so.%sover.*
%dir %_sysconfdir/RHVoice/
%config(noreplace) %_sysconfdir/RHVoice/RHVoice.conf
%_libdir/speech-dispatcher-modules/sd_rhvoice

%package -n lib%{name}_audio%audiosover
Summary: Audio lib files for %name
Group: System/Libraries

%description -n lib%{name}_audio%audiosover
%summary

%files -n lib%{name}_audio%audiosover
%_libdir/lib%{name}_audio.so.%audiosover
%_libdir/lib%{name}_audio.so.%audiosover.*

%package -n lib%{name}_core%coresover
Summary: Core lib file for %name
Group: System/Libraries

%description -n lib%{name}_core%coresover
%summary

%files -n lib%{name}_core%coresover
%_libdir/lib%{name}_core.so.%coresover
%_libdir/lib%{name}_core.so.%coresover.*

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description -n lib%name-devel
Development files for %name

%files -n lib%name-devel
%_includedir/%name.h
%_includedir/%{name}_common.h
%_libdir/lib%name.so
%_libdir/lib%{name}_audio.so
%_libdir/lib%{name}_core.so

%package bin
Summary: Test bin for %name
Group: Other
Requires: %name = %EVR

%description bin
%summary

%files bin
%_bindir/*

%package doc
Summary: Doc for %name
Group: Other
BuildArch: noarch
Requires: %name = %EVR

%description doc
%summary

%files doc
%doc LICENSE.md README.md

# Languages

%define langpackage() \
%package %1 \
Summary: %1 language for  %name \
Group: Sound \
License: %2 \
BuildArch: noarch \
Requires: %name = %EVR \
\
%description %1 \
%summary \
\
%files %1 \
%dir %_datadir/%name/languages/%1 \
%_datadir/%name/languages/%1/* \


%langpackage Russian GPL-2.0
%langpackage English GPL-2.0
%langpackage Albanian GPL-2.0
%langpackage Czech GPL-2.0
%langpackage Croatian GPL-3.0
%langpackage Esperanto GPL-2.0
%langpackage Georgian GPL-2.0
%langpackage Kyrgyz GPL-2.0
%langpackage Macedonian AGPL-3.0
%langpackage Polish GPL-2.0
%langpackage Serbian GPL-3.0
%langpackage Slovak LGPL-2.1
%langpackage Spanish LGPL-2.1
%langpackage Tatar GPL-2.0
%langpackage Ukrainian GPL-2.0
%langpackage Uzbek LGPL-2.1

%package Brazilian
Summary: Brazilian and Portuguese language for  %name
Group: Sound
BuildArch: noarch
Requires: %name = %EVR
Provides: %name-Portuguese = %EVR

%description Brazilian
%summary

%files Brazilian
%dir %_datadir/%name/languages/Brazilian-Portuguese
%_datadir/%name/languages/Brazilian-Portuguese/*


# voices

%define voicepackage() \
%package %1-%2 \
Summary: %1 %2 voice for  %name \
Group: Sound \
License: %3 \
BuildArch: noarch \
Requires: %name-%1 = %EVR \
\
%description %1-%2 \
%summary \
\
%files %1-%2 \
%dir %_datadir/%name/voices/%2 \
%_datadir/%name/voices/%2/* \


# Russian

%voicepackage Russian aleksandr %progectlicense
%voicepackage Russian aleksandr-hq CC-BY-SA-4.0
%voicepackage Russian anna %progectlicense
%voicepackage Russian arina CC-BY-NC-ND-4.0
%voicepackage Russian artemiy CC-BY-NC-ND-4.0
%voicepackage Russian elena GPL-3.0
%voicepackage Russian irina %progectlicense
%voicepackage Russian mikhail CC-BY-NC-ND-4.0
%voicepackage Russian pavel CC-BY-NC-ND-4.0
%voicepackage Russian seva CC-BY-NC-ND-4.0
%voicepackage Russian tatiana CC-BY-NC-ND-4.0
%voicepackage Russian timofey CC-BY-NC-ND-4.0
%voicepackage Russian umka CC-BY-NC-ND-4.0
%voicepackage Russian victoria CC-BY-NC-ND-4.0
%voicepackage Russian vitaliy CC-BY-NC-ND-4.0
%voicepackage Russian vitaliy-ng CC-BY-NC-ND-4.0
%voicepackage Russian vsevolod CC-BY-NC-ND-4.0
%voicepackage Russian yuriy CC-BY-NC-ND-4.0

%package Russian-evgeniy
Summary: Russian evgeniy voice for  %name
Group: Sound
License: CC-BY-NC-ND-4.0
BuildArch: noarch
Requires: %name-Russian = %EVR

%description Russian-evgeniy
%summary

%files Russian-evgeniy
%dir %_datadir/%name/voices/evgeniy-rus
%_datadir/%name/voices/evgeniy-rus/*


# English

%voicepackage English alan %progectlicense
%voicepackage English bdl %progectlicense
%voicepackage English clb %progectlicense
%voicepackage English ksp RHVoice-Natia-License
%voicepackage English lyubov CC-BY-NC-ND-4.0
%voicepackage English slt CMU-License

%package English-evgeniy
Summary: English evgeniy voice for  %name
Group: Sound
License: CC-BY-NC-ND-4.0
BuildArch: noarch
Requires: %name-English = %EVR

%description English-evgeniy
%summary

%files English-evgeniy
%dir %_datadir/%name/voices/evgeniy-eng
%_datadir/%name/voices/evgeniy-eng/*


# Albanian

%voicepackage Albanian hana CC-BY-NC-SA-4.0


# Brazilian-Portuguese

%package Brazilian-Leticia-F123
Summary: Brazilian and Portuguese Leticia-F123 voice for  %name
Group: Sound
License: CC-BY-SA-4.0
BuildArch: noarch
Requires: %name-Brazilian = %EVR
Provides: %name-Portuguese-Leticia-F123 = %EVR

%description Brazilian-Leticia-F123
%summary

%files Brazilian-Leticia-F123
%dir %_datadir/%name/voices/Leticia-F123
%_datadir/%name/voices/Leticia-F123/*


# Czech

%voicepackage Czech radek CC0-1.0
%voicepackage Czech zdenek CC0-1.0

# Croatian

%voicepackage Croatian karmela CC0 1.0


# Esperanto

%voicepackage Esperanto spomenka GPL-3.0


# Georgian

%voicepackage Georgian natia  RHVoice-Natia-License


# Kyrgyz

%voicepackage Kyrgyz azamat %progectlicense
%voicepackage Kyrgyz nazgul %progectlicense


# Macedonian

%voicepackage Macedonian kiko CC-BY-NC-SA-4.0
%voicepackage Macedonian suze %progectlicense


# Polish

%voicepackage Polish alicja CC-BY-4.0
%voicepackage Polish cezary CC-BY-NC-ND-4.0
%voicepackage Polish magda CC-BY-4.0
%voicepackage Polish michal CC0-1.0
%voicepackage Polish natan CC0-1.0


# Serbian

%voicepackage Serbian dragana CC0 1.0


# Slovak

%voicepackage Slovak jasietka CC0-1.0
%voicepackage Slovak ondro CC0-1.0


# Spanish

%voicepackage Spanish Mateo unlicense


# Tatar

%voicepackage Tatar talgat RHVoice-Talgat-License


# Ukrainian

%voicepackage Ukrainian anatol LGPL-2.1
%voicepackage Ukrainian marianna CC-BY-ND-4.0
%voicepackage Ukrainian natalia LGPL-2.1
%voicepackage Ukrainian volodymyr CC-BY-ND-4.0


# Uzbek

%voicepackage Uzbek sevinch CC-BY-NC-SA-4.0
%voicepackage Uzbek dilnavoz CC-BY-NC-SA-4.0
%voicepackage Uzbek islom CC-BY-NC-SA-4.0

%prep
%setup

%build
scons languages=all voices=all audio_libs=all

%install
scons install DESTDIR=%buildroot \
prefix=%prefix sysconfdir=%_sysconfdir bindir=%_bindir libdir=%_libdir includedir=%_includedir datadir=%_datadir

%changelog
