%define _unpackaged_files_terminate_build 1
%def_with gtk4

Name: NetworkManager-strongswan
Version: 1.6.1
Release: alt1

Summary: NetworkManager strongSwan IPSec VPN plug-in

License: GPLv2+
Group: System/Servers
Url: https://www.strongswan.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://download.strongswan.org/NetworkManager/%name-%version.tar.bz2

BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: pkgconfig(libnm) >= 1.1.0
BuildRequires: pkgconfig(libnma) >= 1.1.0
BuildRequires: gettext >= 0.19
%{?_with_gtk4:BuildRequires: pkgconfig(gtk4) >= 4.0 pkgconfig(libnma-gtk4) >= 1.8.33}

Requires: NetworkManager
Requires: strongswan-charon-nm >= 5.9.14

%description
This package contains software for integrating the strongSwan IPSec VPN
with NetworkManager.

%package gtk-common
Summary: Common part of %name GTK support
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description gtk-common
This package contains common part for %name GTK support.

%package gtk3
Summary: Files for GTK3 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %EVR

Obsoletes: %name-gnome < 1.6.0
Provides: %name-gnome = %EVR

%description gtk3
This package contains files for GTK3 applications to use %name.

%package gtk4
Summary: Files for GTK4 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %EVR

%description gtk4
This package contains files for GTK4 applications to use %name.

%prep
%setup

%build
%configure \
        --disable-static \
        --with-charon=/usr/libexec/strongswan/charon-nm \
        %{subst_with gtk4} \
        --enable-more-warnings=no
%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc NEWS
%_libexecdir/NetworkManager/VPN/nm-strongswan-service.name
%_libdir/NetworkManager/libnm-vpn-plugin-strongswan.so
%exclude %_libdir/NetworkManager/libnm-vpn-plugin-strongswan.la

%files gtk-common -f %name.lang
%_libexecdir/NetworkManager/nm-strongswan-auth-dialog
%_datadir/metainfo/*.xml

%files gtk3
%_libdir/NetworkManager/libnm-vpn-plugin-strongswan-editor.so
%exclude %_libdir/NetworkManager/libnm-vpn-plugin-strongswan-editor.la

%if_with gtk4
%files gtk4
%_libdir/NetworkManager/libnm-gtk4-vpn-plugin-strongswan-editor.so
%exclude %_libdir/NetworkManager/libnm-gtk4-vpn-plugin-strongswan-editor.la
%endif

%changelog
