%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
ExcludeArch: %ix86

%def_disable bootstrap
%def_disable docs
%def_with check

%define oname mayavi

Name:           Mayavi
Version:        4.8.2
Release:        alt6
Summary:        Scientific data 3-dimensional visualizer

Group:          Graphics
License:        BSD-3-Clause and EPL-1.0 and LGPL-2.1 and LGPL-3.0
URL:            http://code.enthought.com/projects/mayavi/
VCS:            https://github.com/enthought/mayavi.git
Source:         %name-%version.tar
Source1:        Mayavi.desktop
Source2:        tvtk_doc.desktop

Patch1: %name-alt-test-dependencies.patch
Patch2: drop-imghdr.patch
Patch3: mayavi-pr1329-vtk9.4.patch
Patch4: mayavi-pr1315-np2tests.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: vtk-python3
BuildRequires: libnumpy-py3-devel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pyface
BuildRequires: python3-module-apptools
%endif
%if_enabled docs
BuildRequires: python3-module-setupdocs
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: xvfb-run
%endif
%if_disabled bootstrap
BuildRequires: python3-module-traits python3(traits.api)
%endif

Provides: %oname = %EVR
Requires: python3-module-%oname = %EVR

%add_python3_req_skip test tvtk_classes

%description
The Mayavi project includes two related packages for 3-dimensional
visualization:

 * Mayavi2: A tool for easy and interactive visualization of data.
 * TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

%package -n python3-module-%oname
Summary: Python files for Mayavi, scientific data 3-dimensional visualizer
Group: Development/Python3
Conflicts: %name < %EVR
%add_python3_req_skip wx wxversion
%add_python3_req_skip ipywidgets ipyevents
Requires: python3-module-tvtk = %EVR

%description -n python3-module-%oname
This package contains Python files for Mayavi, scientific data
3-dimensional visualizer.

%package -n python3-module-%oname-tests
Summary: Tests for Mayavi, scientific data 3-dimensional visualizer
Group: Development/Python3
Obsoletes: python3-module-%oname.tests < %EVR
Requires: python3-module-%oname = %EVR
%add_python3_req_skip vtk.numpy_interface

%description -n python3-module-%oname-tests
This package contains tests for Mayavi, scientific data
3-dimensional visualizer.

%package -n python3-module-tvtk
Summary: TVTK: A Traits-based wrapper for the Visualization Toolkit
Group: Development/Python
Conflicts: %name < %EVR
%add_python3_req_skip tvtk.tvtk_classes tvtk.tvtk_classes.vtk_version
%add_python3_req_skip vtk.util vtk.wx.wxVTKRenderWindowInteractor

%description -n python3-module-tvtk
TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

%package -n python3-module-tvtk-tests
Summary: Tests for TVTK
Group: Development/Python3
Obsoletes: python3-module-tvtk.tests < %EVR
Requires: python3-module-tvtk = %EVR

%description -n python3-module-tvtk-tests
TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

This package contains tests for TVTK.

%package doc
Summary: Documentation for Mayavi, scientific data 3-dimensional visualizer
Group: Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%description doc
This package contains documentation for Mayavi, scientific data
3-dimensional visualizer.

%prep
%setup
%autopatch -p1

# Remove pregenerated C sources
grep -lr '/\* Generated by Cython' | xargs rm -v
# Recythonize the sources
find -name '*.pyx' -exec cython {} \;

%build
%if_enabled docs
export PYTHONPATH=$PWD
xvfb-run \
%endif
%pyproject_build

%install
%if_enabled docs
export PYTHONPATH=$PWD
xvfb-run \
%endif
%pyproject_install

install -d %buildroot%_man1dir
install -p -m644 docs/mayavi2.man %buildroot%_man1dir/mayavi2.1

install -d %buildroot%_desktopdir
install -p -m644 %SOURCE1 %SOURCE2 %buildroot%_desktopdir

install -d %buildroot%_liconsdir
install -d %buildroot%_miconsdir
install -d %buildroot%_niconsdir

install -p -m644 docs/source/mayavi/images/mayavi2-48x48.png \
	%buildroot%_liconsdir/mayavi2.png
ln -s %_liconsdir/mayavi2.png %buildroot%_miconsdir/
ln -s %_liconsdir/mayavi2.png %buildroot%_niconsdir/

# remove shebangs from files
find %buildroot%python3_sitelibdir -type f -name '*py' -exec \
	sed -i -e '1!b' -e '/^\#\!\/usr\/bin\/env python$/d' '{}' +

%check
export ETS_TOOLKIT=null
%pyproject_run_pytest -v --pyargs mayavi

%files
%doc image_LICENSE*.txt LICENSE_COLORBREWER.txt LICENSE.txt LICENSE_YORICK.txt
%doc DEVELOPING.rst README.rst README-tvtk.txt
%_bindir/mayavi2
%_bindir/tvtk_doc
%_man1dir/*
%_desktopdir/*
%_liconsdir/*
%_miconsdir/*
%_niconsdir/*

%files -n python3-module-%oname
%python3_sitelibdir/mayavi*
%exclude %python3_sitelibdir/mayavi/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/mayavi/tests

%files -n python3-module-tvtk
%python3_sitelibdir/tvtk
%exclude %python3_sitelibdir/tvtk/tests

%files -n python3-module-tvtk-tests
%python3_sitelibdir/tvtk/tests

%files doc
%doc docs/*.txt docs/pdf examples
%if_enabled docs
%doc docs/build/mayavi
%if_disabled bootstrap
%doc docs/build/tvtk
%endif
%endif

%changelog
