%define _unpackaged_files_terminate_build 1
%define llvm_ver_major 20.1
%define git %nil

# FIXME!
%define optflags_lto %nil

Name:    LLVMSPIRVLib
Version: 20.1.8
Release: alt1
Summary: A tool and a library for bi-directional translation between SPIR-V and LLVM IR
Group:   Development/C++
License: MIT
URL:     https://github.com/KhronosGroup/SPIRV-LLVM-Translator

Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: llvm-spirv-opensycl.patch

BuildRequires(pre): cmake
BuildRequires: llvm%{llvm_ver_major}-devel gcc-c++ libstdc++-devel zlib-devel
BuildRequires: libspirv-tools-devel spirv-headers >= 1.5.5-alt19

%description
LLVM/SPIR-V Bi-Directional Translator, a library and tool for translation
between LLVM IR and SPIR-V.

%package -n lib%name
Summary: %name translator library
Group: System/Libraries
Obsoletes: spirv-llvm-translator
Provides: spirv-llvm-translator = %EVR

%description -n lib%name
LLVM/SPIR-V Bi-Directional Translator, a library and tool for translation
between LLVM IR and SPIR-V.

%package -n lib%name-devel
Summary: %name static libraries
Group: Development/C++
Requires: lib%name = %EVR
Obsoletes: spirv-llvm-translator-devel
Provides: spirv-llvm-translator-devel = %EVR

%description -n lib%name-devel
%name development headers.

%package -n llvm-spirv
Summary: %name translator CLI
Group: Development/C++
Obsoletes: spirv-llvm-translator-tools
Provides: spirv-llvm-translator-tools = %EVR
Requires: lib%name = %EVR

%description -n llvm-spirv
command line utility for translating between LLVM bitcode and SPIR-V binary.

%prep
%setup
%patch0 -p1

%build
%cmake \
  -DLLVM_DIR=%_libexecdir/llvm-%{llvm_ver_major}/%_lib/cmake/llvm \
  -DBUILD_SHARED_LIBS:BOOL=ON \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DBUILD_STATIC_LIBS:BOOL=OFF \
  -DLLVM_EXTERNAL_SPIRV_HEADERS_SOURCE_DIR=%_includedir \
  -DLLVM_SPIRV_BUILD_EXTERNAL=YES
%cmake_build

%install
%cmake_install

%files -n lib%name
%doc LICENSE.TXT
%doc *.md
%_libdir/*%name.so.*

%files -n lib%name-devel
%doc docs/*
%_includedir/*
%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n llvm-spirv
%_bindir/llvm-spirv

%changelog
