#
# Copyright (c) 2004, 2005, 2006, 2007, 2008 Ralf Corsepius, Ulm, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#

%ifarch %ix86
%def_disable man
%else
%def_enable man
%endif
%def_with demos
%def_with examples
%def_with motif

Name: Inventor
Version: 2.1.6
Release: alt1

Summary: SGI Open Inventor (TM)

License: LGPLv2+
Group: Development/C++
Url: https://github.com/aumuell/open-inventor

Packager: Michael Shigorin <mike@altlinux.org>

Source0: %name-%version.tar
Source1: libInventor.pc.in
Source2: libInventorXt.pc.in

%define hackcxxflags -O2 -fno-strict-aliasing

# Automatically added by buildreq on Mon Mar 23 2009
BuildRequires(pre): rpm-build-cmake
BuildRequires: gcc-c++ libGLw-devel libXext-devel libXi-devel libXt-devel libfreetype-devel libjpeg-devel

BuildRequires: gcc-c++
BuildRequires: libGLU-devel
BuildRequires: libGLw-devel
BuildRequires: libXi-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel

%if_with motif
BuildRequires: libopenmotif-devel
%endif
BuildRequires: libfreetype-devel
BuildRequires: libjpeg-devel
BuildRequires: bison
BuildRequires: tcsh

BuildRequires: fonts-ttf-liberation rpm-macros-make

%add_optflags -funsigned-char

%description
SGI Open Inventor(TM) is an object-oriented 3D toolkit offering a
comprehensive solution to interactive graphics programming
problems. It presents a programming model based on a 3D scene database
that dramatically simplifies graphics programming. It includes a rich
set of objects such as cubes, polygons, text, materials, cameras,
lights, trackballs, handle boxes, 3D viewers, and editors that speed
up your programming time and extend your 3D programming capabilities.

%package -n lib%name
Summary: SGI Open Inventor (TM) shared libraries
Group: System/Libraries

%description -n lib%name
SGI Open Inventor (TM) shared libraries

%package -n lib%name-devel
Summary: SGI Open Inventor (TM) development files
Group: Development/C++
Requires: %name = %version-%release
Requires: pkgconfig
Requires: libGLU-devel
Requires: libfreetype-devel libjpeg-devel

%description -n lib%name-devel
SGI Open Inventor (TM) development files

%if_with motif
%package -n libInventorXt
Summary: SGI Open Inventor (TM) Motif bindings
Group: System/Libraries
Requires: %name = %version-%release
Requires: %_bindir/xmessage

%description -n libInventorXt
SGI Open Inventor (TM) development files

%package -n libInventorXt-devel
Summary: SGI Open Inventor (TM) Motif bindings
Group: Development/C++
Requires: %name = %version-%release
Requires: libInventorXt = %version-%release
Requires: libInventor-devel = %version-%release
Requires: pkg-config
Requires: libopenmotif-devel

%description -n libInventorXt-devel
SGI Open Inventor (TM) development files

%endif

%if_with demos
%package demos
Summary: SGI Open Inventor (TM) Demos
Group: Development/Documentation
Requires: %name-data

%description demos
SGI Open Inventor (TM) demos
%endif

%package data
Summary: SGI Open Inventor (TM) data
Group: Development/C++
BuildArch: noarch

%description data
SGI Open Inventor data files

%if_with examples
%package examples
Summary: SGI Open Inventor (TM) source code examples
Group: Development/Documentation
# Should we once ship binary examples, this requirement can be dropped
Requires: libInventorXt-devel
BuildArch: noarch

%description examples
SGI Open Inventor (TM) Source Examples from the Inventor books
"The Inventor Mentor" and "The Inventor Toolmaker"
%endif

%prep
%setup
for i in %SOURCE1 %SOURCE2; do
  sed \
    -e 's,@prefix@,%prefix,g' \
    -e 's,@exec_prefix@,%_exec_prefix,g' \
    -e 's,@includedir@,%_includedir,g' \
    -e 's,@libdir@,%_libdir,g' \
    -e 's,X11R6/lib,X11R6/%_lib,g' \
    < $i > $(basename $i .in)
done

%build
%cmake \
    %if_disabled man
    -DINVENTOR_MAN=OFF \
    %endif
    -DCMAKE_INSTALL_PREFIX=%prefix
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$PWD/%_cmake__builddir/lib
%cmake_build

%install
export FREETYPE=1
%cmake_install

install -d -m755 %buildroot%_pkgconfigdir
install -m644 lib%name.pc %buildroot%_pkgconfigdir
install -m644 lib%{name}Xt.pc %buildroot%_pkgconfigdir

install -d -m755 %buildroot%_datadir/inventor/fonts
# Map Inventor's standard fonts
# Utopia, Helvetica and Courier to liberation-TTF fonts
# Times-Roman is being used by some examples
pushd %buildroot%_datadir/inventor/fonts > /dev/null
ln -s Utopia-Regular Times-Roman
ln -s %_datadir/fonts/ttf/liberation/LiberationSerif-Regular.ttf Utopia-Regular
ln -s %_datadir/fonts/ttf/liberation/LiberationSerif-Bold.ttf Utopia-Bold
ln -s %_datadir/fonts/ttf/liberation/LiberationSerif-Italic.ttf Utopia-Italic
ln -s %_datadir/fonts/ttf/liberation/LiberationSerif-BoldItalic.ttf Utopia-BoldItalic
ln -s %_datadir/fonts/ttf/liberation/LiberationSans-Regular.ttf Helvetica
ln -s %_datadir/fonts/ttf/liberation/LiberationSans-Bold.ttf Helvetica-Bold
ln -s %_datadir/fonts/ttf/liberation/LiberationSans-Italic.ttf Helvetica-Oblique
ln -s %_datadir/fonts/ttf/liberation/LiberationSans-BoldItalic.ttf Helvetica-BoldOblique
ln -s %_datadir/fonts/ttf/liberation/LiberationMono-Regular.ttf Courier
ln -s %_datadir/fonts/ttf/liberation/LiberationMono-Bold.ttf Courier-Bold
ln -s %_datadir/fonts/ttf/liberation/LiberationMono-Italic.ttf Courier-Oblique
ln -s %_datadir/fonts/ttf/liberation/LiberationMono-BoldItalic.ttf Courier-BoldOblique
popd > /dev/null

%files
%doc COPYING KNOWN.BUGS FAQ.misc README.md
%_bindir/iv2toiv1
%_bindir/ivcat
%_bindir/ivdowngrade
%_bindir/ivfix
%_bindir/ivinfo
%_bindir/ivnorm
%_bindir/ivAddVP
%dir %_datadir/inventor
%_datadir/inventor/fonts
%if_enabled man
%_man1dir/inventor.*
%_man1dir/iv2toiv1.*
%_man1dir/ivcat.*
%_man1dir/ivdowngrade.*
%_man1dir/ivfix.*
%_man1dir/ivinfo.*
%endif

%files -n lib%name
%_libdir/libInventor.so.*

%files -n lib%name-devel
%dir %_includedir/Inventor
%_includedir/Inventor/[^X]*
%_libdir/libInventor.so
%_pkgconfigdir/libInventor.pc
%if_enabled man
%_man3dir/Sb*
%_man3dir/So[^X]*
%endif

%if_with motif
%files -n libInventorXt
%_bindir/SceneViewer
%_bindir/ivview
%_bindir/ivperf
%if_enabled man
%_man1dir/SceneViewer.*
%_man1dir/ivview.*
%endif
%_libdir/libInventorXt.so.*
%_libdir/%{name}DSO
%dir %_datadir/inventor
%dir %_datadir/inventor/help
%dir %_datadir/inventor/help/%name
%dir %_datadir/inventor/help/ivview
%_datadir/inventor/help/%name/*.pdf
%dir %_datadir/inventor/data
%_datadir/inventor/help/ivview/ivview.about.pdf

%files -n libInventorXt-devel
%dir %_includedir/Inventor
%_includedir/Inventor/Xt
%_libdir/libInventorXt.so
%_pkgconfigdir/libInventorXt*.pc
%if_enabled man
%_man3dir/SoXt*
%endif
%endif

%files data
%dir %_datadir/inventor
%dir %_datadir/inventor/data
%_datadir/inventor/data/models

%if_with demos
%files demos
# requires data, so dirs already owned
%_datadir/inventor/data/demos
%_libdir/inventor/SceneViewer*
%_libdir/inventor/drop
%_libdir/inventor/gview*
%_libdir/inventor/maze
%_libdir/inventor/noodle*
%_libdir/inventor/qmorf*
%_libdir/inventor/revo*
%_libdir/inventor/textomatic*
%endif

%if_with examples
%files examples
%dir %_datadir/inventor
%endif

%changelog
