%define mversion	7
%define dversion	%mversion.1.2
%define drelease	8
%define qlev		Q16HDRI
%define mgkdir		ImageMagick
%define soname		10
%define sonamepp	5
%def_disable static

%def_with rsvg
%ifarch %e2k
# lcc's openmp implementation is way too old
%def_disable openmp
%else
%def_enable openmp
%endif

Name: ImageMagick
Version: %dversion.%drelease
Release: alt1

Summary: An X application for displaying and manipulating images
License: ImageMagick
Group: Graphics
Url: https://imagemagick.org
VCS: https://github.com/ImageMagick/ImageMagick
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

Source1: %name.desktop
Source2: imagemagick16.png
Source3: imagemagick32.png
Source4: imagemagick48.png
Source5: %name.watch

Requires: ghostscript-classic fonts-type1-urw lib%name%mversion.%soname = %EVR

BuildPreReq: libpng-devel
BuildRequires: libzip-devel

BuildRequires: bzlib-devel curl gcc-c++ glibc-devel-static graphviz groff-base imake libXext-devel libXt-devel libjasper-devel liblqr-devel xdg-utils xorg-cf-files

BuildRequires: libjpeg-devel liblcms2-devel liblzma-devel libwebp-devel libgraphviz-devel libjasper-devel libjbig-devel libtiff-devel libwmf-devel libxml2-devel perl-devel chrpath liblqr-devel libltdl-devel perl-parent
BuildRequires: libheif-devel libraw-devel libraqm-devel libflif-devel libzstd-devel libfftw3-devel
BuildRequires: libpango-devel 
%ifnarch armh
BuildRequires: libjxl-devel
%endif

%{?!_with_bootstrap:BuildRequires: libdjvu-devel openexr-devel transfig libopenjpeg2.0-devel}
%{?_enable_openmp:BuildRequires: libgomp-devel}

%ifarch %e2k
# FIXME: a hack but --disable openmp would still try -fopenmp
#        (enabling it would fail otherwise, see commit message)
BuildRequires: libgomp-devel
%endif

%if_with rsvg
BuildRequires: librsvg-devel
%endif

Requires: %name-tools %name-doc

%description
%name is a powerful image display, conversion and manipulation tool.
It runs in an X session.  With this tool, you can view, edit and display
a variety of image formats.

This package installs the necessary files to run %name.

%package -n lib%name%mversion.%soname
Summary: %name shared libraries
Group: System/Libraries
Provides: %name-lib = %version
Obsoletes: %name-lib < %version
Obsoletes: lib%name < %EVR
Requires: lib%name%mversion-common = %EVR

%description -n lib%name%mversion.%soname
%name is a powerful image display, conversion and manipulation libraries.

%package -n lib%name%mversion-common
Summary: Common files for %name
Group: System/Libraries
Conflicts: libImageMagick <= 6.9.10.86
Conflicts: ImageMagick-tools <= 6.9.10.86

%description -n lib%name%mversion-common
Common files for lib%{name}.

%package -n lib%{name}++%mversion.%sonamepp
Summary: %name shared libraries
Group: System/Libraries

%description -n lib%{name}++%mversion.%sonamepp
%name is a powerful image display, conversion and manipulation libraries.

%package -n lib%name-devel
Summary: Header files for %name app development
Group: Development/C
Requires: lib%name%mversion.%soname = %EVR
%{?_enable_openmp:Requires: libgomp-devel} 
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
If you want to create applications that will use %name code or APIs,
you'll need to install these packages as well as %name.  These additional
packages aren't necessary if you simply want to use %name, however.

%package -n lib%name-devel-static
Summary: Static libraries for %name app development
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
If you want to create applications that will use %name code or APIs,
you'll need to install these packages as well as %name.  These additional
packages aren't necessary if you simply want to use %name, however.

lib%name-devel is an addition to %name which includes static libraries files
necessary to develop applications.

%package -n perl-Magick
Summary: Libraries and modules for access to %name from perl
Group: Development/Perl
Requires: lib%name%mversion.%soname = %EVR
# perl.prov can't get version from inheritance yet
# so we need to add it manually for versioned dependencies.
Provides: perl(Image/Magick.pm) = %mversion.860

%description -n perl-Magick
This is the %name perl support package.  It includes perl modules
and support files for access to %name library from perl.

%package tools
Summary: Console tools from %name
Group: Graphics
Requires: lib%name%mversion.%soname = %EVR
Conflicts: GraphicsMagick-ImageMagick-compat
Provides: convert

%description tools
%name is a powerful image conversion and manipulation tools.
This package installs the necessary files to run %name-tools.

%package doc
Summary: Documentation for %name
Group: Graphics
Requires: %name-tools
BuildArch: noarch

%description doc
Documentation for %name

%prep
%setup -q 
%patch0 -p1
touch config.rpath

%ifarch %e2k
sed -i 's,-lomp,-fopenmp,g' configure* # -lomp was wrong in the first place
%endif

%build
%autoreconf
%configure \
	--with-modules \
	--with-fontpath=%_datadir/fonts/type1/urw \
	--with-gs-font-dir=%_datadir/fonts/type1/urw \
	--with-gvc=yes \
	%{subst_with rsvg} \
	--with-lqr=yes \
	--enable-hdri \
	--with-gcc-arch=no \
	--with-perl \
	--with-xml \
	--with-fftw \
	--with-flif \
	--with-zip \
	%{subst_enable openmp} \
	--with-perl-options="PREFIX=%_prefix INSTALLDIRS=vendor" \
	%{subst_enable static}
subst 's|^\(hardcode_into_libs\)=.*$|\1=no|' libtool
%make_build

pushd PerlMagick
perl Makefile.PL
make
popd

%check
%make check

%install
%make transform='' DESTDIR=%buildroot INSTALLDIRS=vendor install


sed -i "s,%_libdir/libMagickCore.la,-L%_libdir -lMagickCore," %buildroot%_libdir/%mgkdir-%dversion/modules-%qlev/*/*.la

install -pDm644 %SOURCE1 %buildroot%_datadir/applications/%name.desktop
install -pDm644 %SOURCE2 %buildroot%_miconsdir/%name.png
install -pDm644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pDm644 %SOURCE4 %buildroot%_liconsdir/%name.png

chrpath -d %buildroot%perl_vendor_archlib/auto/Image/Magick/%qlev/%qlev.so
chrpath -d %buildroot%perl_vendor_archlib/auto/Image/Magick/Magick.so

mv %buildroot%_docdir/%name-%mversion %buildroot%_docdir/%name-%dversion
%files

%files tools
%_bindir/[a-z]*
%_man1dir/%name.1*
%_man1dir/[a-z]*.1*
# display, menu and icons to be moved into subpackage
%_datadir/applications/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png

%files -n lib%name%mversion-common
%dir %_datadir/%mgkdir-%mversion
%dir %_sysconfdir/%name-%mversion
%_datadir/%mgkdir-%mversion/*
%config %_sysconfdir/%name-%mversion/*

%files doc
%dir %_docdir/%name-%dversion
%dir %_docdir/%name-%dversion/www
%_docdir/%name-%dversion/LICENSE
%_docdir/%name-%dversion/images
%_docdir/%name-%dversion/index.html
%_docdir/%name-%dversion/www/*
%exclude %_docdir/%name-%dversion/www/api
%exclude %_docdir/%name-%dversion/www/Magick++

%files -n lib%name%mversion.%soname
%doc LICENSE
%dir %_libdir/%mgkdir-%dversion
%dir %_libdir/%mgkdir-%dversion/modules-%qlev
%dir %_libdir/%mgkdir-%dversion/modules-%qlev/coders
%dir %_libdir/%mgkdir-%dversion/modules-%qlev/filters
%_libdir/%mgkdir-%dversion/modules-%qlev/*/*
%_libdir/libMagickWand*.so.%{soname}*
%_libdir/libMagickCore*.so.%{soname}*

%files -n lib%{name}++%mversion.%sonamepp
%_libdir/*++*.so.%{sonamepp}*

%files -n lib%name-devel
%dir %_docdir/%name-%dversion
%dir %_docdir/%name-%dversion/www
%_docdir/%name-%dversion/www/api
%_docdir/%name-%dversion/www/Magick++
%_bindir/*-config
%_includedir/*
%_libdir/*.so
%_libdir/%mgkdir-%dversion/config-%qlev
%_pkgconfigdir/*.pc
%_man1dir/*-config.1*

%files -n perl-Magick
%doc www/perl-magick.html images/examples.jpg PerlMagick/demo
%perl_vendor_archlib/Image
%perl_vendor_autolib/Image

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
