Name: CUnit
Version: 2.1.3
Release: alt2.svn20140424
Summary: A lightweight system for unit tests in C

Group: System/Libraries
License: LGPLv2+
Url: http://cunit.sourceforge.net/
Packager: Mykola Grechukh <gns@altlinux.ru>

Source: http://downloads.sourceforge.net/cunit/%name-%version.tar

Patch1: 0001-Fix-compiling-with-opaque-ncurses.patch
Patch2: 0002-Fix-snprintf-format-and-arguments-in-curses_suite_le.patch
Patch3: 0003-Fix-printf-width-argument-type-across-multiple-modul.patch
Patch4: 0004-Fix-suppressing-unused-result-warning-for-fgets.patch

BuildRequires: libncurses-devel

%description
CUnit is a lightweight system for writing, administering, and running unit
tests in C.  It provides C programmers a basic testing functionality with a
flexible variety of user interfaces.

CUnit is built as a static library which is linked with the user's testing
code. It uses a simple framework for building test structures, and provides
a rich set of assertions for testing common data types.  In addition,
several different interfaces are provided for running tests and reporting
results.

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%autopatch -p1
sed -i '/^CURSES_OBJECT_FILES_SHARED/ s,$, -l\$\(CURSES_LIB\),' CUnit/Sources/Makefile.am

%build
%autoreconf
%configure \
	--enable-curses \
	--disable-static
%make_build

%install
%makeinstall_std

# move /usr/doc/CUnit
mv -f %buildroot%prefix/doc/%name docs
rm -rf docs/headers

%files
%doc AUTHORS ChangeLog COPYING NEWS README TODO
%_libdir/*.so.*
%_datadir/%name
%_mandir/*/%{name}*

%files devel
%doc docs/*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
