%define _pseudouser_user     _3proxy
%define _pseudouser_group    _3proxy
#define _pseudouser_home     %_localstatedir/_3proxy
%define _pseudouser_home     /

Name: 3proxy
Version: 0.6.1
Release: alt3

Summary: Proxy server

License: BSD-3-Clause
Group: System/Servers
Url: https://github.com/3proxy/3proxy


Source: %name-%version.tar
Source1: 3proxy.init
Source2: 3proxy.conf
Source3: 3proxy.sysconfig
Source4: README-ALT.CP1251
Source5: README-ALT.UTF8

Patch1: %name-%version-alt-droproot.patch
Patch2: %name-%version-alt-changes.patch
Patch3: CVE-2019-14495.patch

Packager: Afanasov Dmitry <ender@altlinux.org>

BuildRequires: libcap-devel

%description
3proxy -- light proxy server.

%prep
%setup -q 
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
sed -i '/^CFLAGS/s/$/ -Wno-error=incompatible-pointer-types -Wno-pointer-sign/' Makefile.Linux Makefile.unix
%make_build -f Makefile.Linux
cp %SOURCE5 %SOURCE4 ./

%install
mkdir -p %buildroot%_sysconfdir
mkdir -p %buildroot%_sysconfdir
mkdir -p %buildroot%_man3dir
mkdir -p %buildroot%_man8dir
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_logdir/%name
mkdir -p %buildroot%_var/run/%name
install -m755 -D src/3proxy %buildroot%_bindir/3proxy
install -m755 -D src/dighosts %buildroot%_bindir/dighosts
install -m755 -D src/ftppr %buildroot%_bindir/ftppr
install -m755 -D src/mycrypt %buildroot%_bindir/mycrypt
install -m755 -D src/pop3p %buildroot%_bindir/pop3p
install -m755 -D src/proxy %buildroot%_bindir/proxy
install -m755 -D src/socks %buildroot%_bindir/socks
install -m755 -D src/tcppm %buildroot%_bindir/tcppm
install -m755 -D src/udppm %buildroot%_bindir/udppm
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/3proxy
install -m644 %SOURCE2 %buildroot%_sysconfdir/3proxy.conf

install -pD -m644 man/*.3 %buildroot%_man3dir
install -pD -m644 man/*.8 %buildroot%_man8dir

install -pD -m644 authors %buildroot%_datadir/%name-%version/AUTHORS
install -pD -m644 copying %buildroot%_datadir/%name-%version/COPYING
install -pD -m644 news %buildroot%_datadir/%name-%version/NEWS
install -pD -m644 Readme %buildroot%_datadir/%name-%version/README
install -pD -m644 Changelog %buildroot%_datadir/%name-%version/Changelog
install -pD -m644 README-ALT* %buildroot%_datadir/%name-%version/

%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'The 3proxy daemon' \
        -d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%preun
%preun_service %name

%post
%post_service %name

%files
%_bindir/*
%config(noreplace) %_sysconfdir/3proxy.conf
%config(noreplace) %_sysconfdir/sysconfig/3proxy
%_initdir/%name
%_man3dir/*
%_man8dir/*
%attr(775, root, %_pseudouser_group) %_logdir/%name
%attr(775, root, %_pseudouser_group) %_var/run/%name
%_datadir/%name-%version

%changelog
