Name: 0ad
Epoch: 1
Version: 0.27.1
Release: alt1

Summary: Libre realtime strategy game of ancient warfare
License: GPL-2.0-or-later and MIT
Group: Games/Strategy
Url: https://play0ad.com/
VCS: https://gitea.wildfiregames.com/0ad/0ad.git

Requires: %name-data = %version
Requires: fonts-ttf-dejavu

Source: %name-%version.tar
Source1: cxxtest.tar
# https://svn.wildfiregames.com/public/source-libs/trunk/fcollada/src/
# libraries/source/fcollada/build.sh
Source2: fcollada.tar

Patch1: 0ad-0.27-alt-loongarch64-and-riscv64.patch
Patch2: 0ad-0.27.1-upstream-mozjs128.patch
Patch3: 0ad-0.27-alt-mozjs128-strict-mode.patch

BuildRequires: boost-filesystem-devel
BuildRequires: boost-flyweight-devel
BuildRequires: boost-lockfree-devel
BuildRequires: boost-signals-devel
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libGL-devel
BuildRequires: libSDL2-devel
BuildRequires: libXcursor-devel
BuildRequires: libblitz-devel
BuildRequires: libcurl-devel
BuildRequires: libenet-devel
BuildRequires: libfmt-devel
BuildRequires: libfreetype-devel
BuildRequires: libgloox-devel
BuildRequires: libicu-devel
BuildRequires: libjpeg-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libmozjs128-devel
BuildRequires: libnspr-devel
BuildRequires: libopenal-devel
BuildRequires: libpng-devel
BuildRequires: libsodium-devel
BuildRequires: libvorbis-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: libxml2-devel
BuildRequires: premake5
BuildRequires: python3-dev
BuildRequires: zlib-devel

%ifarch %intel x86_64 aarch64
BuildRequires: libdispatch-devel
%endif

# premake5 requires /proc/self/exe
BuildRequires: /proc

%description
0 A.D. (pronounced "zero ey-dee") is a free software, cross-platform
real-time strategy (RTS) game of ancient warfare. In short, it is a
historically-based war/economy game that allows players to relive or
rewrite the history of Western civilizations, focusing on the years
between 500 B.C. and 500 A.D. The project is highly ambitious, involving
state-of-the-art 3D graphics, detailed artwork, sound, and a flexible
and powerful custom-built game engine.

The game has been in development by Wildfire Games (WFG), a group of
volunteer, hobbyist game developers, since 2001. The code and data are
available under the GPL license, and the art, sound and documentation
are available under CC-BY-SA. In short, we consider 0 A.D. an an
educational celebration of game development and ancient history.

%prep
%setup -a1 -a2
%autopatch -p1

# specify build version for GUI
echo \
  "L\"%version\"" > build/build_version/build_version.txt

# update shebangs from python to python3
find . -name '*.py' -o -name 'cxxtestgen' | xargs sed -i \
	-e '1 s:#!%_bindir/env python$:#!%_bindir/env python3:' \
	-e '1 s:#! %_bindir/env python$:#! %_bindir/env python3:' \
	%nil

%build
%ifarch ppc64le
export CPPFLAGS="%optflags -maltivec"
export CFLAGS="%optflags -maltivec"
%else
export CFLAGS="%optflags"
export CFLAGS="%optflags"
%endif

# build bundled library
pushd libraries/source/fcollada
./build.sh
popd

export SHELL=/bin/sh
[ -n "$NPROCS" ] || NPROCS=%__nprocs
build/workspaces/update-workspaces.sh \
  --bindir=%_bindir \
  --datadir=%_datadir/0ad \
  -j$NPROCS \
  --libdir=%_libdir/0ad \
  --without-nvtt \
  --with-system-mozjs \
  --with-system-premake5 \
  #

%make_build -C build/workspaces/gcc verbose=1

%install
install -Dm 0755 binaries/system/libAtlasUI.so %buildroot%_libdir/0ad/libAtlasUI.so
install -Dm 0755 binaries/system/libCollada.so %buildroot%_libdir/0ad/libCollada.so
install -Dm 0755 binaries/system/pyrogenesis %buildroot%_bindir/pyrogenesis
install -Dm 0755 binaries/system/pyrogenesis %buildroot%_bindir/ActorEditor

install -Dm 0644 build/resources/0ad.desktop %buildroot%_desktopdir/0ad.desktop
install -Dm 0644 build/resources/0ad.png %buildroot%_pixmapsdir/0ad.png

ln -s pyrogenesis %buildroot%_bindir/0ad
mkdir -p %buildroot%_datadir/0ad
cp -a binaries/data/l10n %buildroot%_datadir/0ad/

%files
%doc LICENSE.md
%dir %_libdir/0ad
%_bindir/0ad
%_bindir/pyrogenesis
%_bindir/ActorEditor
%_datadir/0ad/*
%_desktopdir/0ad.desktop
%_libdir/0ad/*.so
%_pixmapsdir/0ad.png

%changelog
