%define soname 2
%define gname zimg

Name: zimg
Version: 3.0.6
Release: alt1

Summary: Scaling, color space conversion, and dithering library

License: WTFPL
Group: System/Libraries
Url: https://github.com/sekrit-twc/zimg
VCS: https://github.com/sekrit-twc/zimg

Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/release-%version/%gname-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ autoconf automake libtool

%description
The "z" library implements the commonly required image processing basics of
scaling, color space conversion, and depth conversion. A simple API enables
conversion between any supported formats to operate with minimal knowledge from
the programmer. All library routines were designed from the ground-up with
correctness, flexibility, and thread-safety as first priorities. Allocation,
buffering, and I/O are cleanly separated from processing, allowing the
programmer to adapt "z" to many scenarios.

%package -n lib%name%soname
Summary: %summary
Group: System/Libraries
Provides: lib%name = %version
Obsoletes: lib%name

%description -n lib%name%soname
The "z" library implements the commonly required image processing basics of
scaling, color space conversion, and depth conversion. A simple API enables
conversion between any supported formats to operate with minimal knowledge from
the programmer. All library routines were designed from the ground-up with
correctness, flexibility, and thread-safety as first priorities. Allocation,
buffering, and I/O are cleanly separated from processing, allowing the
programmer to adapt "z" to many scenarios.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C++

%description -n lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n zimg-release-%version
%patch -p1

%build
autoreconf -vif
%configure \
    --disable-static \
    --disable-testapp
%make_build V=1

%install
%makeinstall_std
#install -m 755 -p -D testapp %%buildroot%%_bindir/testapp

find %buildroot -name '*.la' -delete

# Pick up docs in the files section
rm -fr %buildroot%_docdir/%gname

%files -n lib%name%soname
%doc COPYING README.md ChangeLog
%_libdir/lib%gname.so.%{soname}*

%files -n lib%name-devel
#_bindir/testapp
%_includedir/*
%_libdir/lib%gname.so
%_pkgconfigdir/%gname.pc

%changelog
