%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%define ver_major 49
%define beta %nil
%define api_ver 1
%define xdg_name org.gnome.Yelp

%def_disable debug
%def_enable lzma
%def_disable gtk_doc

%define webkit_api_ver 6.0

%def_enable check

Name: yelp
Version: %ver_major.0
Release: alt1%beta

Summary: Lightweight help browser for GNOME
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: http://yelp.io

Vcs: https://gitlab.gnome.org/GNOME/yelp.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define gio_ver 2.68
%define gtk_ver 4.16
%define adw_ver 1.6
%define xslt_ver 1.1.4
%define webkit_ver 2.40
%define yelpxsl_ver %ver_major

Requires: lib%name = %version-%release
Requires: yelp-xsl >= %yelpxsl_ver
Requires: dconf
%ifarch %e2k
Obsoletes: yelp.sh
%endif

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson itstool gtk-doc
BuildRequires: libgio-devel >= %gio_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: libxslt-devel >= %xslt_ver
BuildRequires: pkgconfig(webkitgtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: yelp-xsl >= %yelpxsl_ver
BuildRequires: zlib-devel bzlib-devel libsqlite3-devel
%{?_enable_lzma:BuildRequires: liblzma-devel}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation. The name Yelp was suggested by Daniel Lundin.
Yelp is pronounced the same as the swedish word for 'help'.

%package -n lib%name
Summary: Shared library for Yelp
Group: System/Libraries

%description -n lib%name
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package provides shared library required for Yelp to work

%package -n lib%name-devel
Summary: Development files for Yelp library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This is a Yelp development package. Contains files needed for doing
development using Yelp.

%package -n lib%name-devel-doc
Summary: Development documentation for Yelp library
Group: Development/C
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
Yelp is a help browser for the GNOME desktop. Yelp provides
a simple graphical interface for viewing DocBook, HTML, man, and info
formatted documentation.

This package contains documentation needed for doing development using
Yelp.


%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature lzma lzma}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/gnome-help
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_datadir/yelp-xsl/xslt/common/domains/yelp.xml
%config %_datadir/glib-2.0/schemas/org.gnome.yelp.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc AUTHORS README* NEWS TODO

%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%_libdir/%name-%api_ver/

%files -n lib%name-devel
%_includedir/lib%name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/lib%name-%api_ver.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/lib%name/
%endif

%changelog
