# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define sover 10

Name: yara
Version: 4.5.5
Release: alt1
License: BSD-3-Clause and Apache-2.0
Group: Development/Tools
Summary: The pattern matching swiss knife for malware researchers (and everyone else)
Url: http://virustotal.github.io/yara/
Vcs: https://github.com/virustotal/yara
# Docs: https://yara.readthedocs.io/

Source: %name-%version.tar
BuildRequires: flex
BuildRequires: libjansson-devel
BuildRequires: libmagic-devel
BuildRequires: libprotobuf-c-devel
BuildRequires: libssl-devel
BuildRequires: protobuf-compiler

%description
YARA is a tool aimed at (but not limited to) helping malware researchers to
identify and classify malware samples. With YARA you can create descriptions of
malware families (or whatever you want to describe) based on textual or binary
patterns. Each description, a.k.a rule, consists of a set of strings and a
boolean expression which determine its logic.

%package -n libyara%sover
Summary: YARA dynamic libraries (pattern matcher)
Group: System/Libraries

%description -n libyara%sover
Dynamic library for YARA.

%package -n libyara-devel
Summary: YARA development files (pattern matcher)
Group: Development/C
Requires: libyara%sover = %EVR
AutoReqProv: nocpp

%description -n libyara-devel
Development files for YARA.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
#	--disable-static
# make[2]: *** No rule to make target 'libyara/.libs/libyara.a', needed by 'test-arena'.  Stop.
%configure \
	--with-crypto	\
	--enable-cuckoo	\
	--enable-magic	\
	--enable-macho	\
	--enable-dex	\
	--enable-pb-tests
%make_build

%install
%makeinstall_std
rm -f %buildroot%_libdir/libyara.a

%check
# Parallel make -j check does not work anymore:
# https://github.com/VirusTotal/yara/issues/1667
%make check VERBOSE=1
export LD_LIBRARY_PATH=%buildroot%_libdir PATH=%buildroot%_bindir:$PATH
yara --version
cat > main.rule <<'EOF'
rule MAIN {
  strings:   $my = /Name:/
  condition: $my
}
EOF
yarac main.rule /tmp/a
yara main.rule -r . | grep MAIN.*yara.spec

%files
%doc AUTHORS CONTRIBUTORS README.md COPYING
%_bindir/yara*
%_man1dir/yara*.1*

%files -n libyara%sover
%_libdir/libyara.so.%sover
%_libdir/libyara.so.%sover.*

%files -n libyara-devel
%_libdir/libyara.so
%_includedir/yara*
%_pkgconfigdir/yara.pc

%changelog
