%define _unpackaged_files_terminate_build 1

Name: xz-java
Version: 1.10
Release: alt1

Summary: Java implementation of XZ data compression
License: 0BSD
Group: Development/Java
Url: http://tukaani.org/xz/java.html
VCS: https://github.com/tukaani-project/xz-java.git
BuildArch: noarch

Source0: %name-%version.tar

BuildRequires: javapackages-local
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
BuildRequires: ant

%description
A complete implementation of XZ data compression in Java.

It features full support for the .xz file format specification version 1.0.4,
single-threaded streamed compression and decompression, single-threaded
decompression with limited random access support, raw streams (no .xz headers)
for advanced users, including LZMA2 with preset dictionary.

%package javadoc
Group: Development/Java
Summary: Javadocs for xz-java
BuildArch: noarch

%description javadoc
This package contains the API documentation for xz-java.

%prep
%setup

%mvn_file :xz xz-java/xz

%build
# During documentation generation the upstream build.xml tries to download
# package-list from oracle.com. Create a dummy package-list to prevent that.
mkdir -p extdoc && touch extdoc/package-list

%ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  maven

%install
%mvn_artifact build/maven/xz-%version.pom build/jar/xz.jar

%mvn_install -J build/doc

%files -f .mfiles
%doc README.md THANKS.md
%doc --no-dereference COPYING

%files javadoc -f .mfiles-javadoc
%doc --no-dereference COPYING

%changelog
