Name: xxhash
Version: 0.8.3
Release: alt1

Summary: Extremely fast hash algorithm
# xxhash.c and xxhash.h are BSD-2-Clause
# xxhsum.c is GPL-2.0-or-later
License: BSD-2-Clause and GPL-2.0-or-later
Group: File tools
Url: http://www.xxhash.com/
Vcs: https://github.com/Cyan4973/xxHash
# git://git.altlinux.org/gears/x/xxhash.git
Source: %name-%version-%release.tar

%description
xxHash is an Extremely fast Hash algorithm, running at RAM speed limits.
It successfully completes the SMHasher test suite which evaluates collision,
dispersion and randomness qualities of hash functions.  Code is highly
portable, and hashes are identical across all platforms (little / big endian).

%package -n lib%name
Summary: Extremely fast hash algorithm - library
License: BSD-2-Clause
Group: System/Libraries

%description -n lib%name
xxHash is an Extremely fast Hash algorithm, running at RAM speed limits.
It successfully completes the SMHasher test suite which evaluates collision,
dispersion and randomness qualities of hash functions.  Code is highly
portable, and hashes are identical across all platforms (little / big endian).

%package -n lib%name-devel
Summary: Extremely fast hash algorithm - development files
License: BSD-2-Clause
Requires: lib%name = %EVR
Group: Development/C

%description -n lib%name-devel
Development files for the xxhash library.

%prep
%setup -n %name-%version-%release

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build libxxhash xxhsum xxh32sum xxh64sum xxh128sum xxhsum_inlinedXXH \
	MOREFLAGS="$RPM_OPT_FLAGS"
rm xxhsum
mv xxhsum_inlinedXXH xxhsum

%install
export CC=false CXX=false # nothing should be compiled or linked during install
%makeinstall_std PREFIX=%_prefix LIBDIR=%_libdir
rm -rf %buildroot%_libdir/*.a

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
make check
make test-xxhsum-c

%files
%_bindir/xxh*sum
%_man1dir/xxh*sum.1*
%doc CHANGELOG LICENSE README.md

%files -n lib%name
%_libdir/libxxhash.so.*
%doc CHANGELOG LICENSE README.md

%files -n lib%name-devel
%_includedir/xxhash.h
%_includedir/xxh3.h
%_libdir/libxxhash.so
%_pkgconfigdir/libxxhash.pc

%changelog
